<?php

namespace App\Http\Controllers\Admin;

use App\Models\RideDriver;
use Illuminate\Http\Request;
use App\Exports\RideDriverExport;
use App\Models\RideDriverDetails;
use App\Exports\RideDetailsExport;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;
use App\Http\Requests\Admin\Ride\RideDriverExportRequest;

class RideController extends Controller
{
    /**
     * Display a listing of the resource./dashboard/rides
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
{
    // If no date filters are provided, return an empty result
    if (!$request->filled('start_date') && !$request->filled('end_date')) {
        return view('admin.rides.index', ['result' => null]); // No data until a filter is applied
    }

    // Start query
    $result = RideDriver::query();

    // Apply filtering based on available date inputs
    if ($request->filled('start_date') && $request->filled('end_date')) {
        $result->whereBetween('created_at', [$request->start_date, $request->end_date]);
    } elseif ($request->filled('start_date')) {
        $result->whereDate('created_at', '>=', $request->start_date);
    } elseif ($request->filled('end_date')) {
        $result->whereDate('created_at', '<=', $request->end_date);
    }

    // Load relationships and execute query
    $result = $result->with(["user:id,name,phone", "client:id,name,phone", "endPoints", "startPoint"])->get();

    return view('admin.rides.index', compact('result'));
}


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function details($rideId)
    {
        $rideDetails = RideDriverDetails::where('ride_driver_id', $rideId)->orderBy('created_at', 'desc')->get();
        Log::info($rideDetails);
        return view('admin.rides.details',compact('rideDetails','rideId'));
        
    }
    public function exportDetails($id){
        return Excel::download(new RideDetailsExport($id), 'RideDetails.xlsx');
    }
    public function export(RideDriverExportRequest $request)
    {
        // Validate request
        $validatedData = $request->validated();

        // Get filter values from request
        $startDate = $validatedData['start_date'] ?? null;
        $endDate = $validatedData['end_date'] ?? null;
        $search = $validatedData['search'] ?? null;

        // Apply filtering logic like in the index method
        $query = RideDriver::query();

        if ($startDate && $endDate) {
            $query->whereBetween('created_at', [$startDate, $endDate]);
        } elseif ($startDate) {
            $query->whereDate('created_at', '>=', $startDate);
        } elseif ($endDate) {
            $query->whereDate('created_at', '<=', $endDate);
        }

        
        // if ($search = request('search')) {
        //     $query->where(function ($query) use ($search) {
        //         $query->Where('client_description', 'like', "%{$search}%")
        //             ->orWhere('total_price', 'like', "%{$search}%")
        //             ->orWhere('actual_price', 'like', "%{$search}%")
        //             ->orWhere('total_distance', 'like', "%{$search}%")
        //             ->orWhere('actual_distance', 'like', "%{$search}%")
            
        
        //             // Search inside `user` (Driver Info)
        //             ->orWhereHas('user', function ($query) use ($search) {
        //                 $query->where('name', 'like', "%{$search}%")
        //                       ->orWhere('phone', 'like', "%{$search}%");
        //             })
        
        //             // Search inside `client`
        //             ->orWhereHas('client', function ($query) use ($search) {
        //                 $query->where('name', 'like', "%{$search}%")
        //                       ->orWhere('phone', 'like', "%{$search}%");
        //             });
        
        //     });
        // }
        

        // Load related data like in the `index` method
        $rides = $query->with(["user:id,name,phone", "client:id,name,phone", "endPoints", "startPoint"])->get();
        // Log::info($rides);
        // Export the data
        return Excel::download(new RideDriverExport($rides), 'ride_drivers.xlsx');
    }
}
