<?php

namespace App\Http\Controllers\Admin;

use App\Models\RideBonus;
use Illuminate\Http\Request;
use App\Exports\RideBonusExport;
use App\Models\DriverRidesBonusLog;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;
use App\Http\Requests\Admin\RidesBonus\EditRequest;
use App\Http\Requests\Admin\RidesBonus\StoreRequest;

class RidesBonusController extends Controller
{
    public function index()
    {
        $ridesBonus = RideBonus::orderByDesc('updated_at')->get();
        return view('admin.ridesBonus.index', compact('ridesBonus'));
    }


    // public function store(StoreRequest $request)
    public function store(StoreRequest $request)
    {
        Log::info('request');
        Log::info($request);
        $validatedData = $request->validated();
        $validatedData['time_from'] = \Carbon\Carbon::parse($validatedData['time_from'])->format('Y-m-d H:i:s');
        $validatedData['time_to'] = \Carbon\Carbon::parse($validatedData['time_to'])->format('Y-m-d H:i:s');

        $rideBonus = RideBonus::create($validatedData);
        $rideBonus->update(['rides_number' => $rideBonus->id + 1000]);

        return redirect()->route('admin.riders_bonus.index')
            ->with('success', 'Ride Bonus created successfully.');
    }


    public function update(EditRequest $request)
    {
        // Log::info($request->all());
        $id=$request->id;
        $request->validated();
        $ridesBonus = RideBonus::find($id);

        $ridesBonus->update($request->all());

        return redirect()->route('admin.riders_bonus.index')
            ->with('success', 'Ride Bonus updated successfully.');
    }

    public function changeEnable(Request $id)
    {
        $ridesBonus = RideBonus::find($id->id);
        if($ridesBonus->enable == 1){
            $ridesBonus->update(['enable' => 0]);
        }else{
            $ridesBonus->update(['enable' => 1]);
        }
        
        return redirect()->route('admin.riders_bonus.index')
            ->with('success', 'Ride Bonus enable status changed successfully.');
    }
    public function logs(Request $request){
        $driverRidesBonusLog = DriverRidesBonusLog::where('id_rides_bonus', $request->id)
            ->with(['rideDriver', 'rideDriver.user'])
            ->get(); 
        // Log::info($driverRidesBonusLog[0]->rideDriver->user->name);
        return view('admin.ridesBonus.logs', compact('driverRidesBonusLog'));
    }
    public function export()
    {
        return Excel::download(new RideBonusExport(), 'ride_bonus.xlsx');
    }
}
