<?php

namespace App\Http\Controllers\Admin;

use App\Models\Toll;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;

class TollController extends Controller
{
    public function index()
    {
        $tolls = Toll::all();
        return view("admin.toll.index",compact('tolls'));
    }


    // public function store(Request $request)
    // {
    //     $validated = $request->validate([
    //         'toll_description' => 'required|string|max:255',
    //         'cost' => 'required|numeric',
    //         'road' => 'required|string|max:255',
    //     ]);
    //     $toll = Toll::create($validated);
    //     return response()->json([
    //         'message' => 'Toll created successfully',
    //         'data' => $toll
    //     ]);
    // }


    public function update(Request $request)
    {
        Log::info( $request);

        $validated = $request->validate([
            'toll_description' => 'sometimes|string|max:255',
            'cost' => 'sometimes|numeric',
            'road' => 'sometimes|string|max:255',
        ]);

        $toll = Toll::findOrFail($request->id);
        $toll->update($validated);

        return back()->with('success',trans('lang.updated')); 
    }

  

    public function enable(Request $request)
    {
        Log::info($request);
        $toll = Toll::find($request->id);
        
        if ($toll) {
            $toll->enable = !$toll->enable;
            $toll->save();
            Log::info($toll);
            return redirect()->route('tolls.index')->with('success', trans('lang.updated'));
        }

        return redirect()->route('tolls.index')->with('error', trans('lang.not_found'));
    }
}
