<?php

namespace App\Http\Controllers\Admin;

use App\Models\City;
use App\Models\CarType;
use App\Exports\UsersExport;
use Illuminate\Http\Request;
use App\Traits\NotificationTrait;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;
use App\Http\Requests\Client\EditRequest;
use App\Models\{CarModel, User,UserAdress};

class UsersController extends Controller
{
    use NotificationTrait;
    public function index(Request $request){
        $this->lang();
        $clients=User::query()->with("region:id,$this->locale");
        // if($request->regionId){
        //     $clients =$clients->join('address_user', 'address_user.user_id' ,'users.id')
        //     ->where('address_user.region_id' , $request->regionId);
        // }
        $clients =$clients
        ->select('users.id' ,'users.name' ,'city_id' , 'users.phone' 
        ,'subscription_end_date','subscription_start_date','active','users.device_id',
        'users.created_at')->get();
        return view('admin.drivers.index',compact('clients'));
    }
    

    public function details(User $user){
         $this->lang();
     $user= $user->load("region:id,$this->locale","carModel:id,$this->locale","carType:id,$this->locale");
     // return $user;
     return view('admin.drivers.details',compact('user'));
    }
    
    public function edit(User $user){
        $this->lang();
    $user= $user->load("region:id,$this->locale","carModel:id,$this->locale","carType:id,$this->locale");
    $carTypes=CarType::select('id',"$this->locale as name")->get();
    $carModels=CarModel::select('id',"$this->locale as name")->get();
    $city=City::select('id',"$this->locale as name")->whereNotNull('parent_id')->get();
        Log::info($user);
        // return $user;
        // $user=User::find($id);
    //   return $user=json_decode($user,true);
        return view('admin.drivers.edit',compact('user','carTypes','carModels','city'));
    }

    public function update(EditRequest $request,$id){
        // return "here";
        $data=$request->validated();
        // Log::info($data);
        // if($user->subscription_end_date<now()){
        //     $data['active']=0;
        // }
        $user=User::find($request->id);
        $user->update($data);
        // $user->syncRoles([$request->role_id]);
        
        if($request->active==1){
            
            $notification=
            [
                'type' => "1",
                'title' => "حالة المستخدم",
                'title_en' => "User status",
                'message' => "تم تنشيط حسابكم",
                'message_en' => "Your account has been activated",
            ];
            $subscribers=[$user->device_id];
            
            $this->sendNotification($data_send=$notification,$subscribers);
        }
        elseif($request->active==2){
            
            $notification=
            [
                'type' => "1",
                'title' => "حالة المستخدم",
                'title_en' => "User status",
                'message' => "تم ايقاف حسابكم مؤقتا الرجاء التواصل مع الدعم",
                'message_en' => "Your account is temporarily suspended. Please contact support",
            ];
            $subscribers=[$user->device_id];
      
            $this->sendNotification($data_send=$notification,$subscribers);
            
        }
       
        return  to_route('admin.drivers')->with('success',trans('lang.updated')); 
    }



    public function resetPassword(Request $request){
        $client=User::find($request->client_id);
        $client->update(['password' => $request->password]);
        return back()->with('success',trans('lang.updated'));
    }

    public function export(){
        return Excel::download(new UsersExport, 'users.xlsx');
    }



}
