<?php

namespace App\Http\Controllers\Driver;

use Carbon\Carbon;
use App\Models\RideBonus;
use App\Models\RideDriver;
use Illuminate\Http\Request;
use App\Traits\ResponsesTrait;
use App\Models\DriverRidesBonusLog;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;

class DriverRidesBonusLogController extends Controller
{
    use ResponsesTrait;


    // public function getRidesBonusData(){
    //     $ridesBonus = RidesDriver:: ;

    // }

    private function saveBonusLogs($ridesDriversData) {
        foreach ($ridesDriversData as &$data) {
            foreach ($data['rides_driver'] as $rideDriver) {
            $existingBonusLog = DriverRidesBonusLog::where('id_rides_bonus', $data['rides_bonus']->id)->where('id_rides_driver', $rideDriver->id)->first();
            if (!$existingBonusLog) {
                $bonus = new DriverRidesBonusLog;
                $bonus->id_rides_bonus = $data['rides_bonus']->id;
                $bonus->id_rides_driver = $rideDriver->id;
                Log::info($data['rides_driver']);
                $bonus->save();
                }
                }
            }
        }
    
    public function dailyBonus(){
        $RideBonus = RideBonus::where('type', 'daily')->where('enable', 1)->get();
        Log::info($RideBonus);
        
        $ridesDriversData = [];
        foreach ($RideBonus as $bonus) {
            $ridesDrivers = RideDriver::whereBetween('updated_at', [$bonus->time_from, $bonus->time_to])->get();
            $ridesDriversData[] = [
            'rides_bonus' => $bonus,
            'rides_driver' => $ridesDrivers
            ];
        }

        $this->saveBonusLogs($ridesDriversData);

        return $this->success('Rides Bonus', $ridesDriversData);
        }

    public function weeklyBonus(){
        $RideBonus = RideBonus::where('type', 'weekly')->where('enable', 1)->get();
        
        $ridesDriversData = [];
        foreach ($RideBonus as $bonus) {
            $ridesDrivers = RideDriver::whereBetween('updated_at', [$bonus->time_from, $bonus->time_to])
                ->whereRaw('DAYOFWEEK(updated_at) = 7') 
                ->get();
            $ridesDriversData[] = [
                'rides_bonus' => $bonus,
                'rides_driver' => $ridesDrivers
            ];
        }

        $this->saveBonusLogs($ridesDriversData);

        return $this->success('Rides Bonus', $ridesDriversData);
    }
    
    
    
    public function monthlyBonus(){
            $RideBonus = RideBonus::where('type', 'monthly')->where('enable', 1)->get();
            $ridesDriversData = [];
            foreach ($RideBonus as $bonus) {
                $ridesDrivers = RideDriver::whereBetween('updated_at', [$bonus->time_from, $bonus->time_to])->get();
                $ridesDriversData[] = [
                'rides_bonus' => $bonus,
                'rides_driver' => $ridesDrivers
                ];
            }
            $this->saveBonusLogs($ridesDriversData);

            return $this->success('Rides Bonus', $ridesDriversData);
        }



}
