<?php

namespace App\Http\Controllers\Driver;
use App\Models\User;
use App\Models\Client;
use App\Models\RideDriver;
use Illuminate\Http\Request;
use App\Services\UserService;
use App\Traits\ResponsesTrait;
use App\Models\DriverEditRequest;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use App\Http\Requests\Client\EditProfileRequest;

class ProfileController extends Controller
{
    use ResponsesTrait;
    private $userRepository;
    private $userService;
    public function __construct(UserService $userService)
    {
        $this->userService = $userService;  
    }

    function indexWeb(Request $request){
        // return $request->all();
        $user=User::find($request->id);
        if($user){
                  $ride=RideDriver::where(['user_id'=>$user->id,'status'=>'0'])->first();
                if($ride){
                        return view('profile',compact('ride'));
                }else{
                        return view('profile',compact('user'));
            }
          
        }
       
    }

    function indexClientWeb(Request $request){
        // return $request->all();
        $user=Client::find($request->id);
        if($user){
                   $ride=RideDriver::where(['client_id'=>$user->id,'status'=>'0'])->first();
                // if($ride){
                        return view('client_profile',compact('ride'));
                // }
                // else{
                        // return view('profile',compact('user'));
            // }
          
        }
       
    }
    function index(){
        return $this->success( $this->userService->findCurrentUser());
    }

    function update(EditProfileRequest $request){
        Log::info("update profile" );
        // $user= $this->userService->updateCurrentUser($request->validated());
        $id=auth()->id();
        $data=array_merge(
            $request->validated(),
            ['driver_id' => $id]
        );
        Log::info($data);
        $user=DriverEditRequest::create($data);
        return $this->success($user,trans('lang.request_has_been_sent'));
    }
    
    function updateLang(Request $request){
        Log::info("update lang" );
        // auth()->user()->update(['lang'=>$request->lang]);
        return $this->success(null,trans('lang.updated'));
    }
    
    function updateLocation(Request $request){
        Log::info("updateLocation" );
        auth()->user()->update(['lang'=>$request->lang,'lat'=>$request->lat]);
        return $this->success(null,trans('lang.updated'));
    }
    
      function updateStatus(Request $request){

        Log::info("update updateStatus" );
        $user=auth()->user();
        $user=auth()->user()->update(['is_online'=>!$user->is_online]);
        return $this->success(auth()->user(),trans('lang.updated'));
    }
    
    
    public function destroy(){
        $this->userService->deleteCurrentUser();
        return $this->success(null,trans('lang.deleted'));
    }


    public function editRequest(){
        $user=auth()->user();
        $request=DriverEditRequest::where('driver_id',$user->id)->get();
        return $this->success($request);
    }
}
