<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\AuditLog;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;


class AuditLogActions
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $response = $next($request);

        // Get the current authenticated driver (modify if needed to match your authentication)
        if (!Auth::guard('client')->check()) {

        $driver = Auth::user();  // Adjust this if the driver is not authenticated via default guard

        if ($driver) {
            // Get the controller and method from the current route
            $routeAction = $request->route()->getAction();
            $actionType = $this->getActionType($routeAction);

            // Log the driver action
            AuditLog::create([
                'driver_id'   => $driver->id,
                'driver_name' => $driver->name,
                'action_type' => $actionType,
                'action_date' => now(),
            ]);
        }
}
        return $response;
    }


    protected function getActionType($routeAction)
    {
        if (isset($routeAction['controller'])) {
            // Extract controller and method from the action string
            [$controller, $method] = explode('@', $routeAction['controller']);
            return class_basename($controller) . '-' . $method;
        }
        return 'UnknownAction';
    }
}
