<?php

namespace App\Http\Requests\Admin\AuditLog;

use Illuminate\Foundation\Http\FormRequest;

class AuditLogExportRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            'start_date' => 'nullable|date',
            'end_date' => 'nullable|date|after_or_equal:start_date',
            'search' => 'nullable|string|max:255',
        ];
    }


    public function messages(): array
    {
        return [
            'end_date.after_or_equal' => __('lang.end_date_after_start'),
        ];
    }
}
