<?php

namespace App\Http\Requests\Admin\RidesBonus;

use Illuminate\Foundation\Http\FormRequest;

class StoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'bonus_name'   => 'sometimes|required|string|max:255',
            'description'  => 'sometimes|nullable|string',

            'type'         => 'required|in:daily,weekly,monthly',
            // 'rides_number' => 'sometimes|nullable|integer',
            'bonus_type'   => 'required|in:money,percentage',
            // 'enable'       => 'required|boolean',
            'bonus_value'  => 'required|integer',
            'time_from' => 'required|date_format:Y-m-d\TH:i',
            'time_to'   => 'required|date_format:Y-m-d\TH:i|after:time_from',
        ];
    }
    
    public function messages(): array
    {
        return [
            'bonus_name.required'   => 'The bonus name field is required when present.',
            'bonus_name.string'     => 'The bonus name must be a valid string.',
            'bonus_name.max'        => 'The bonus name must not exceed 255 characters.',

            'description.string'    => 'The description must be a valid string.',
            

            'type.required'         => 'The type field is required.',
            'type.in'               => 'The type must be one of the following values: daily, weekly, or monthly.',
    
            // 'rides_number.integer'  => 'The rides number must be an integer.',
    
            'bonus_type.required'   => 'The bonus type field is required.',
            'bonus_type.in'         => 'The bonus type must be either money or percentage.',
    
            // 'enable.required'       => 'The enable field is required.',
            // 'enable.boolean'        => 'The enable field must be true or false.',
    
            'bonus_value.required'  => 'The bonus value field is required.',
            'bonus_value.integer'   => 'The bonus value must be an integer.',
    
            'time_from.required'    => 'The start date and time field is required.',
            'time_from.date_format' => 'The start date and time must be in the format YYYY-MM-DDTHH:MM.',
    
            'time_to.required'      => 'The end date and time field is required.',
            'time_to.date_format'   => 'The end date and time must be in the format YYYY-MM-DDTHH:MM.',
            'time_to.after'         => 'The end date and time must be after the start date and time.',

        ];
    }
    
    
}
