<?php

namespace App\Http\Requests\Client;

use Illuminate\Foundation\Http\FormRequest;

class EditRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            // 'id' => 'required',
            'active' => 'required',
            'password' => 'sometimes|nullable',
            'subscription_start_date' => 'required|',
            'subscription_end_date' => 'required|after_or_equal:subscription_start_date|after_or_equal:'.date('Y-m-d'),

            'birth_date' => 'nullable|date',
            'car_color' => 'nullable|string|max:255',
            'city_id' => 'required|exists:cities,id',
            'model_year' => 'nullable|integer|min:1900|max:' . date('Y'),
            'car_model_id' => 'required|exists:car_models,id',
            'car_type_id' => 'nullable|string|max:255',

            'car_license'      => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'image'            => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'driving_license'  => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'blood_analysis'   => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'criminal_record'  => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ];
    }
    
    public function messages(): array {
        return [
            'id.required'  => 'The id is required',
            'active.required'  => 'The code is cover',
  
            "subscription_end_date.after_or_equal" =>'the end date should be after or equal today',
            
            "subscription_start_date.after_or_equal" =>'the start  date should be after or equal today',


            'birth_date.date' => 'The birth date must be a valid date.',


    
            'car_color.string' => 'The car color must be a valid string.',
            'car_color.max' => 'The car color must not exceed 255 characters.',
            'city_id.required' => 'Please select a region.',
            'city_id.exists' => 'The selected region is invalid.',

            
    
            'model_year.required' => 'The model year is required.',
            'model_year.integer' => 'The model year must be a valid number.',
            'model_year.min' => 'The model year must be at least 1900.',
            'model_year.max' => 'The model year must not exceed the current year.',
    
            'car_model_id.string' => 'The car model must be a valid string.',
            'car_model_id.max' => 'The car model must not exceed 255 characters.',
    
            'car_type_id.string' => 'The car type must be a valid string.',
            'car_type_id.max' => 'The car type must not exceed 255 characters.',

              // Image Uploads
            'car_license.image' => 'The car license must be a valid image.',
            'car_license.mimes' => 'The car license must be a file of type: jpeg, png, jpg, gif, or svg.',
            'car_license.max' => 'The car license image size must not exceed 2MB.',

            'image.image' => 'The image must be a valid image.',
            'image.mimes' => 'The image must be a file of type: jpeg, png, jpg, gif, or svg.',
            'image.max' => 'The image size must not exceed 2MB.',

            'driving_license.image' => 'The driving license must be a valid image.',
            'driving_license.mimes' => 'The driving license must be a file of type: jpeg, png, jpg, gif, or svg.',
            'driving_license.max'  => 'The driving license image size must not exceed 2MB.',

            'blood_analysis.image' => 'The blood analysis must be a valid image.',
            'blood_analysis.mimes' => 'The blood analysis must be a file of type: jpeg, png, jpg, gif, or svg.',
            'blood_analysis.max' => 'The blood analysis image size must not exceed 2MB.',

            'criminal_record.image' => 'The criminal record must be a valid image.',
            'criminal_record.mimes' => 'The criminal record must be a file of type: jpeg, png, jpg, gif, or svg.',
            'criminal_record.max' => 'The criminal record image size must not exceed 2MB.',
        ];
    }

}
