<?php

namespace App\Models;

use App\Models\User;
use App\Traits\FileUploadTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
// use SebastianBergmann\CodeCoverage\Driver\Driver;

class DriverEditRequest extends Model
{
    use HasFactory;
    use FileUploadTrait;

    protected $table = 'driver_profile_edit_requests';

    protected $fillable = [
        'driver_id', 'phone', 'car_color', 'car_license', 'driving_license',
        'image', 'model_year', 'car_type_id', 'car_model_id', 'request_status','rejection_reason'
    ];


    public function setImageAttribute($value)
    {
        // $this->attributes['image'] = $this->uploadFile($value,'profiles',$this->attributes['image'] ?? "");
        $this->attributes['image'] = $this->uploadFileWithoutDelete($value,'profiles',$this->attributes['image'] ?? "");
    }
    
    public function setCarImageAttribute($value)
    {
        // $this->attributes['car_image'] = $this->uploadFile($value,'profiles',$this->attributes['car_image'] ?? "");
        $this->attributes['car_image'] = $this->uploadFileWithoutDelete($value,'profiles',$this->attributes['car_image'] ?? "");
    }
    
    public function setCheckImageAttribute($value)
    {
        // $this->attributes['check_image'] = $this->uploadFile($value,'profiles',$this->attributes['check_image'] ?? "");
        $this->attributes['check_image'] = $this->uploadFileWithoutDelete($value,'profiles',$this->attributes['check_image'] ?? "");
    }

    public function setDrivingLicenseAttribute($value)
    {
        // $this->attributes['driving_license'] = $this->uploadFile($value,'driving_license',$this->attributes['driving_license'] ?? "");
        $this->attributes['driving_license'] = $this->uploadFileWithoutDelete($value,'driving_license',$this->attributes['driving_license'] ?? "");
    }
    
    public function setBloodAnalysisAttribute($value)
    {
        // $this->attributes['blood_analysis'] = $this->uploadFile($value,'blood_analysis',$this->attributes['blood_analysis'] ?? "");
        $this->attributes['blood_analysis'] = $this->uploadFileWithoutDelete($value,'blood_analysis',$this->attributes['blood_analysis'] ?? "");
    }
    
    public function setCriminalRecordAttribute($value)
    {
        // $this->attributes['criminal_record'] = $this->uploadFile($value,'criminal_record',$this->attributes['criminal_record'] ?? "");
        $this->attributes['criminal_record'] = $this->uploadFileWithoutDelete($value,'criminal_record',$this->attributes['criminal_record'] ?? "");
    }

    public function setCarLicenseAttribute($value)
    {
        // $this->attributes['car_license'] = $this->uploadFile($value,'car_license',$this->attributes['car_license'] ?? "");
        $this->attributes['car_license'] = $this->uploadFileWithoutDelete($value,'car_license',$this->attributes['car_license'] ?? "");
    }
    public function user()
{
    return $this->belongsTo(User::class, 'driver_id', 'id');
}


}
