<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DriverRidesBonusLog extends Model
{
    use HasFactory;


    protected $table = 'driver_rides_bonus_log';

    protected $fillable = [
        'id_rides_driver',
        'id_rides_bonus',
    ];

    public function rideDriver()
    {
        return $this->belongsTo(RideDriver::class, 'id_rides_driver');
    }

    public function rideBonus()
    {
        return $this->belongsTo(RideBonus::class, 'id_rides_bonus');
    }
}
