<?php

namespace App\Models;

use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class RideDriver extends Model
{
    use HasFactory;
    const start=0;
    const acceptNotDelivered=2;
    const acceptDelivered=3;
    const customerArrived=5;
    const finsih=1;
    const cancelled=4;
    protected $table="ride_driver";
    protected $fillable = [
        'user_id' ,  'client_id' ,   'city_id',
        'total_price','actual_price' ,
        'total_time' ,'actual_time' ,
        'total_distance' ,'actual_distance',
        'total_waiting_time' , 'total_waiting_time_fee' ,
        'status' ,'start_fee' ,'km_fee' ,'waiting_fee',
        'driver_rate' , 'car_rate' , 'client_description',
        'airport_fee'
    ]; 

    // public function setUserIdAttribute()
    // {
    //     $this->attributes['user_id'] =Auth::user()->id;
    // }

    protected $hidden = [
        
    ]; 


    protected $dates =[
        "created_at",
        'updated_at'
       
    ];
    public function user(){
        return $this->belongsTo(User::class,'user_id');
    }
    public function client(){
        return $this->belongsTo(Client::class);
    }


    public function startPoint(){
        return $this->hasOne(RideDriverDetails::class)->where("is_start_point",1)->select(['ride_driver_id','name','is_start_point' ,'lang','lat']);
    }

    public function endPoints(){
        return $this->hasMany(RideDriverDetails::class)->where("is_end_point",1)->select(['ride_driver_id','name','is_end_point']);
    }
    public function endPointsDetails(){
        return $this->hasMany(RideDriverDetails::class)->where("is_end_point",1)->select(['ride_driver_id','name','is_end_point','lang','lat']);
    }
    
    public function serializeDate($date)
    {
        return $date->format('Y-m-d h:i:s'); // Format the date as desired
    }

    public function getActualDistanceAttribute($value)
    {
        return number_format($value, 2, '.', ',');
    }

    public function getActualPriceAttribute($value)
    {
        return number_format($value, 2, '.', ',');
    }

}
