<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ride_driver_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('ride_driver_id')->index();
            $table->double('lang',8,8);
            $table->double('lat',8,8);
            $table->boolean("is_start_point")->default(false);
            $table->boolean("is_end_point")->default(false);
            $table->boolean("is_stop_point")->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ride_driver_details');
    }
};
