@extends('admin.layout.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">
@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3>@lang('lang.clients')</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">@lang('lang.Users')</li>
<li class="breadcrumb-item active">@lang('lang.clients')</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">

		<div class="col-sm-12">
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
						<table class="display" id="advance-1">
							<div style="position: relative ;height: 50px;">
								<a style="position: absolute;left:0 ; "href="{{route('admin.export.clients')}}" >
								
									<svg xmlns="http://www.w3.org/2000/svg" style="width: 20px;" viewBox="0 0 576 512"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path d="M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 128-168 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l168 0 0 112c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM384 336l0-48 110.1 0-39-39c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l80 80c9.4 9.4 9.4 24.6 0 33.9l-80 80c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l39-39L384 336zm0-208l-128 0L256 0 384 128z"/></svg>
								</a>
							</div>
							<thead>
								<tr class="text-center">
                                    <th>@lang('lang.Name')</th>
									<th class="text-center">@lang('lang.phone')</th>
									<th class="text-center">@lang('lang.Status')</th>
									<th>@lang('lang.gender')</th>
									<th>@lang('lang.created_at')</th>
									<th></th>								
								</tr>
							</thead>
							<tbody>
								@forelse ($clients as $client)
									<tr class="text-center">
										<td>{{ $client->name }}</td>
										<td class="text-center">{{ $client->phone}}</td>
										<td class="text-center">
											@if ($client->active ==1)
											@lang('lang.active')
											@elseif($client->active ==2)
											@lang('lang.stop')	

											@else
											@lang('lang.inactive')	
											@endif
											
										</td>
                                        <td class="text-center">
											{{ trans("lang.$client->gender")}}
										</td>

										<td>{{ $client->created_at?->format('Y-m-d') }}</td>
										<td>
											 @can('edit admin')
                                             @if ($client->active ==1)
                                                <a class="btn btn-success"  href="{{ route('admin.clients.changeStatus',$client) }}">
                                                    @lang('lang.active')
                                                </a>
                                            @else
                                                <a class="btn btn-danger"  href="{{ route('admin.clients.changeStatus',$client) }}">
                                                    @lang('lang.inactive')
                                                </a>
                                            @endif
											@endcan	
											{{--
											@can('edit admin')
											<a class="btn btn-success"  href="{{ route('admin.drivers.details',$client) }}">
												@lang('lang.details')</a>
											@endcan	 --}}

										</td>
									</tr>
								@empty
									
								@endforelse
								
							</tbody>
							<tfoot>
							<tr class="text-center">
									<th>@lang('lang.Name')</th>
									<th class="text-center">@lang('lang.phone')</th>
									<th class="text-center">@lang('lang.Status')</th>
									<th>@lang('lang.gender')</th>
									<th>@lang('lang.created_at')</th>
									<th></th>								
								</tr>
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	
	</div>
</div>



@endsection
<script>

	function getId(id){
		document.getElementById("client_id").value=id;
	}
	</script>
@section('script')

<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>
@endsection