@extends('admin.layout.master')
@section('title', 'Validation Forms')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/select2.css')}}">

@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3>@lang('lang.edit_driver')</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">@lang('lang.Drivers')</li>
<li class="breadcrumb-item active">@lang('lang.edit_driver')</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
		<div class="col-sm-12">
			<div class="card">
				<div class="card-body">
					<form class="needs-validation" novalidate="" method="POST" enctype="multipart/form-data" action="{{ route('admin.drivers.update',$user->id) }}">
                        @csrf
						@method("PUT")
						<div class="row">
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">@lang('lang.Name')</label>
								<input class="form-control" id="validationCustom01" type="text" name="name" value="{{ $user->name}}" placeholder="" required="" disabled>
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a name.</div>
							</div>
						
							<div class="col-md-6 mb-3">
								<label for="validationCustom02">@lang('lang.phone')</label>
								<input class="form-control" id="validationCustom02" type="text" name="phone"  value="{{ $user->phone}}" placeholder="" required="" disabled>
								<div class="valid-feedback">Looks good!</div>
								@error('phone')
								    <div class="alert alert-danger">{{ $message }}</div>
							    @enderror
							</div>
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom01">@lang('lang.status')</label>

                                <select class="js-example-placeholder-multiple col-sm-12"  id="validationCustom01"  name="active" required="">
                                  
									<option value="1" @selected($user->active==1) >@lang('lang.active')</option>
									<option value="0" @selected($user->active==0) >@lang('lang.inactive')</option>
									<option value="2" @selected($user->active==2) >@lang('lang.stop')</option>

                              
                                </select>
                                <div class="invalid-feedback">Please provide a valid status.</div>

                            </div>

					
						</div>
						<div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom01">@lang('lang.subscription_start_date')</label>
                                <input class="form-control" id="validationCustom01" type="date" name="subscription_start_date" value="{{ old('subscription_start_date', $user->subscription_start_date?->format('Y-m-d')) }}" required>
                                <div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a date.</div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom01">@lang('lang.subscription_end_date')</label>
                                <input class="form-control" id="validationCustom01" type="date" name="subscription_end_date" value="{{ old('subscription_end_date', $user->subscription_end_date?->format('Y-m-d')) }}" required>
                                <div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a date.</div>
                            </div>
                        </div>

						<div class="row">
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">@lang('lang.birth_date')</label>
								<input class="form-control" id="validationCustom01" type="date"  value="{{ old('birth_date', $user->birth_date?->format('Y-m-d'))??'' }}" >
								<div class="valid-feedback">Looks good!</div>
								<div class="invalid-feedback">Please choose a date.</div>
							</div>
							

							<div class="col-md-6 mb-3">
								<label for="validationCustom05">@lang('lang.password')</label>
								<input class="form-control" id="validationCustom05" type="password" placeholder="********" name="password"  >
								<div class="invalid-feedback">Please provide a valid password.</div>
							</div>
						</div>
						
						

					<div class="row">

						
						
						
						
						<div class="col-md-6 mb-3">
							<label for="validationCustom01">@lang('lang.car_color')</label>
							<input class="form-control" id="validationCustom01" type="text" name="car_color" value="{{ $user->car_color}}" >
							<div class="valid-feedback">Looks good!</div>
							<div class="invalid-feedback">Please choose a name.</div>
						</div>
						
						{{-- <div class="col-md-6 mb-3">
							<label for="validationCustom01">@lang('lang.region')</label>
							<input class="form-control" id="validationCustom01" type="text"  value="{{ $user->region->name}}" >
							<div class="valid-feedback">Looks good!</div>
							<div class="invalid-feedback">Please choose a name.</div>
						</div> --}}
						<div class="col-md-6 mb-3">
							<label for="region">@lang('lang.region')</label>
							<select class="form-control js-example-placeholder-multiple col-sm-12" id="region" name="city_id" required>
								{{-- <option value="">@lang('lang.select_region')</option> --}}
								@foreach($city as $region)
									<option value="{{ $region->id }}" @if($user->region->id == $region->id) selected @endif>
										{{ $region->name }}
									</option>
								@endforeach
							</select>
							<div class="invalid-feedback">Please choose a region.</div>
						</div>
						
						
						<div class="col-md-6 mb-3">
							<label for="validationCustom01">@lang('lang.model_year')</label>
							<input class="form-control" id="validationCustom01" type="text" name="model_year" value="{{ $user->model_year}}" >
							<div class="valid-feedback">Looks good!</div>
							<div class="invalid-feedback">Please choose a name.</div>
						</div>
						{{-- <div class="col-md-6 mb-3">
							<label for="validationCustom01">@lang('lang.carModel')</label>
							<input class="form-control" id="validationCustom01" type="text"  value="{{ $user->carModel->name}}" >
							<div class="valid-feedback">Looks good!</div>
							<div class="invalid-feedback">Please choose a name.</div>
						</div> --}}
						<div class="col-md-6 mb-3">
							<label for="carModel">@lang('lang.carModel')</label>
							<select class="form-control js-example-placeholder-multiple col-sm-12" id="carModel" name="car_model_id" required>
								{{-- <option value="">@lang('lang.select_car_model')</option> --}}
								@foreach($carModels as $model)
									<option value="{{ $model->id }}" @if($user->carModel->id == $model->id) selected @endif>
										{{ $model->name }}
									</option>
								@endforeach
							</select>
							<div class="invalid-feedback">Please choose a car model.</div>
						</div>
						
						<div class="col-md-6 mb-3">
							<label for="carType">@lang('lang.carType')</label>
							<select class="form-control js-example-placeholder-multiple col-sm-12" id="carType" name="car_type_id" required>
								{{-- <option value="">@lang('lang.select_car_type')</option> --}}
								@foreach($carTypes as $type)
									<option value="{{ $type->id }}" @if($user->carType->id == $type->id) selected @endif>
										{{ $type->name }}
									</option>
								@endforeach
							</select>
							<div class="invalid-feedback">Please choose a car type.</div>
						</div>
						
						
						<div class="row">
							<!-- Car License Upload & View -->
							<div class="col-md-6 mb-3">
								<label for="car_license_upload">@lang('lang.car_license')</label>
								<input class="form-control" type="file" id="car_license_upload" name="car_license" onchange="updateImagePreview('car_license_view_button', this)">
								<button type="button" class="btn btn-primary mt-2" id="car_license_view_button" 
									onclick="openImageModal('@lang('lang.car_license')', this.getAttribute('data-img'))"
									data-img="{{ asset($user->car_license) }}">
									@lang('lang.view')
								</button>
							</div>

							<!-- Image Upload & View -->
							<div class="col-md-6 mb-3">
								<label for="image_upload">@lang('lang.Image')</label>
								<input class="form-control" type="file" id="image_upload" name="image" onchange="updateImagePreview('image_view_button', this)">
								<button type="button" class="btn btn-primary mt-2" id="image_view_button" 
									onclick="openImageModal('@lang('lang.Image')', this.getAttribute('data-img'))"
									data-img="{{ asset($user->image) }}">
									@lang('lang.view')
								</button>
							</div>

							<!-- Driving License Upload & View -->
							<div class="col-md-6 mb-3">
								<label for="driving_license_upload">@lang('lang.driving_license')</label>
								<input class="form-control" type="file" id="driving_license_upload" name="driving_license" onchange="updateImagePreview('driving_license_view_button', this)">
								<button type="button" class="btn btn-primary mt-2" id="driving_license_view_button" 
									onclick="openImageModal('@lang('lang.driving_license')', this.getAttribute('data-img'))"
									data-img="{{ asset($user->driving_license) }}">
									@lang('lang.view')
								</button>
							</div>

							<!-- Blood Analysis Upload & View -->
							<div class="col-md-6 mb-3">
								<label for="blood_analysis_upload">@lang('lang.blood_analysis')</label>
								<input class="form-control" type="file" id="blood_analysis_upload" name="blood_analysis" onchange="updateImagePreview('blood_analysis_view_button', this)">
								<button type="button" class="btn btn-primary mt-2" id="blood_analysis_view_button" 
									onclick="openImageModal('@lang('lang.blood_analysis')', this.getAttribute('data-img'))"
									data-img="{{ asset($user->blood_analysis) }}">
									@lang('lang.view')
								</button>
							</div>

							<!-- Criminal Record Upload & View -->
							<div class="col-md-6 mb-3">
								<label for="criminal_record_upload">@lang('lang.criminal_record')</label>
								<input class="form-control" type="file" id="criminal_record_upload" accept="image/*" name="criminal_record" onchange="updateImagePreview('criminal_record_view_button', this)">
								<button type="button" class="btn btn-primary mt-2" id="criminal_record_view_button" 
									onclick="openImageModal('@lang('lang.criminal_record')', this.getAttribute('data-img'))"
									data-img="{{ asset($user->criminal_record) }}">
									@lang('lang.view')
								</button>
							</div>
						</div>

						<!-- Modal for Image Preview -->
						
						



						<div class="text-center">
							<button class="btn btn-danger" >
								<a href="{{route('admin.drivers')}}" style="color: white" >
									@lang('lang.cancel')
								</a>
							</button>
							<button class="btn btn-primary" type="submit">@lang('lang.save')</button>
                        </div>

						
					</div>
						
					</form>
				</div>
			</div>
			
		
		</div>
	</div>
</div>
<div class="modal fade" id="imageModal" tabindex="-1" aria-labelledby="imageModalLabel" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-dialog-centered-custom">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="imageModalLabel"></h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body text-center">
				<img id="modalImage" src="" class="img-fluid rounded" alt="">
			</div>
		</div>
	</div>
</div>
@endsection

<script>
    // Function to update the data-img attribute of the view button when an image is uploaded
    function updateImagePreview(buttonId, input) {
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            reader.onload = function(e) {
                // Update the button's data-img attribute with the new image URL
                document.getElementById(buttonId).setAttribute('data-img', e.target.result);
            };
            reader.readAsDataURL(input.files[0]);
        }
    }

    // Function to open the modal with the uploaded or existing image
    function openImageModal(title, imagePath) {
        document.getElementById('imageModalLabel').innerText = title;
        document.getElementById('modalImage').src = imagePath;
        var imageModal = new bootstrap.Modal(document.getElementById('imageModal'));
        imageModal.show();
    }
</script>

@section('script')
<script src="{{asset('assets/js/select2/select2.full.min.js')}}"></script>
<script src="{{asset('assets/js/select2/select2-custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>
@endsection