@extends('admin.layout.master')
@section('title', 'Validation Forms')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/select2.css')}}">

@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3>@lang('lang.details')</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">@lang('lang.edits_request')</li>
<li class="breadcrumb-item active">@lang('lang.details')</li>
@endsection

@section('content')
<div class="container-fluid">


	<form action="{{ route('admin.edit_requests.update', $editRequest->id) }}" class="m-5" method="POST">
		@csrf
		@method('PUT')
	
		<button type="submit"  name="action" value="approve" class="btn btn-success">@lang('lang.approve')	</button>
		<button type="button" class="btn btn-danger reject-button" 
			{{$editRequest?->request_status =="approved" ? 'disabled' : ''}}>
		@lang('lang.reject')
	</button>
		{{-- <button type="submit" {{$editRequest?->request_status =="approved" ? 'disabled' : ''}} name="action" value="reject" class="btn btn-danger">@lang('lang.reject')	</button> --}}
	</form>


	<div class="row">
		<div class="col-sm-12">
			<div class="card">
				<div class="card-body">
				
						<div class="row">
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">@lang('lang.Name')</label>
								<input class="form-control" id="validationCustom01" type="text" name="name" value="{{ $editRequest->user->name}}" disabled>
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a name.</div>
							</div>
						
							<div class="col-md-6 mb-3">
								<label for="validationCustom02">@lang('lang.phone')</label>
								<input class="form-control" id="validationCustom02" type="text" name="phone"  value="{{ $editRequest->user->phone}}" disabled>
								<div class="valid-feedback">Looks good!</div>
								@error('phone')
								    <div class="alert alert-danger">{{ $message }}</div>
							    @enderror
							</div>
                     

					
						</div>

						<div class="row">
                
                            
                        
                    
                            <div class="col-md-6 mb-3">
								<label for="validationCustom01">@lang('lang.Name')</label>
								<input class="form-control" id="validationCustom01" type="text"  value="{{ $editRequest?->name}}" disabled>
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a name.</div>
							</div>
							
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">@lang('lang.car_color')</label>
								<input class="form-control" id="validationCustom01" type="text"  value="{{ $editRequest?->car_color}}" disabled>
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a name.</div>
							</div>
							
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">@lang('lang.region')</label>
								<input class="form-control" id="validationCustom01" type="text"  value="{{ $editRequest?->region?->name}}" disabled>
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a name.</div>
							</div>
							
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">@lang('lang.model_year')</label>
								<input class="form-control" id="validationCustom01" type="text"  value="{{ $editRequest?->model_year}}" disabled>
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a name.</div>
							</div>
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">@lang('lang.carModel')</label>
								<input class="form-control" id="validationCustom01" type="text"  value="{{ $editRequest?->carModel?->name}}" disabled>
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a name.</div>
							</div>
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">@lang('lang.carType')</label>
								<input class="form-control" id="validationCustom01" type="text" value="{{ $editRequest?->carType?->name}}" disabled>
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a name.</div>
							</div>
							
                            
                            <div class="col-md-6 mb-3">
						
						        <a href="{{asset($editRequest->car_license)}}" download rel="noopener noreferrer" 
						        target="_blank" class="btn btn-success"> @lang('lang.downloadFile_car_license')
                                </a>
								<button type="button" class="btn btn-primary"
            onclick="openImageModal('@lang('lang.car_license')', '{{ asset($editRequest->car_license) }}')">
            {{-- <svg xmlns="http://www.w3.org/2000/svg" style="width: 16px; " viewBox="0 0 576 512"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path d="M288 80c-65.2 0-118.8 29.6-159.9 67.7C89.6 183.5 63 226 49.4 256c13.6 30 40.2 72.5 78.6 108.3C169.2 402.4 222.8 432 288 432s118.8-29.6 159.9-67.7C486.4 328.5 513 286 526.6 256c-13.6-30-40.2-72.5-78.6-108.3C406.8 109.6 353.2 80 288 80zM95.4 112.6C142.5 68.8 207.2 32 288 32s145.5 36.8 192.6 80.6c46.8 43.5 78.1 95.4 93 131.1c3.3 7.9 3.3 16.7 0 24.6c-14.9 35.7-46.2 87.7-93 131.1C433.5 443.2 368.8 480 288 480s-145.5-36.8-192.6-80.6C48.6 356 17.3 304 2.5 268.3c-3.3-7.9-3.3-16.7 0-24.6C17.3 208 48.6 156 95.4 112.6zM288 336c44.2 0 80-35.8 80-80s-35.8-80-80-80c-.7 0-1.3 0-2 0c1.3 5.1 2 10.5 2 16c0 35.3-28.7 64-64 64c-5.5 0-10.9-.7-16-2c0 .7 0 1.3 0 2c0 44.2 35.8 80 80 80zm0-208a128 128 0 1 1 0 256 128 128 0 1 1 0-256z"/></svg> --}}
			 @lang('lang.view')
        </button>
							</div>
							
                            <div class="col-md-6 mb-3">
						
						        <a href="{{asset($editRequest->image)}}" download rel="noopener noreferrer" 
						        target="_blank" class="btn btn-success"> @lang('lang.downloadFile_image')
                                </a>
								<button type="button" class="btn btn-primary"
            onclick="openImageModal('@lang('lang.Image')', '{{ asset($editRequest->image) }}')">
            {{-- <svg xmlns="http://www.w3.org/2000/svg" style="width: 16px; " viewBox="0 0 576 512"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path d="M288 80c-65.2 0-118.8 29.6-159.9 67.7C89.6 183.5 63 226 49.4 256c13.6 30 40.2 72.5 78.6 108.3C169.2 402.4 222.8 432 288 432s118.8-29.6 159.9-67.7C486.4 328.5 513 286 526.6 256c-13.6-30-40.2-72.5-78.6-108.3C406.8 109.6 353.2 80 288 80zM95.4 112.6C142.5 68.8 207.2 32 288 32s145.5 36.8 192.6 80.6c46.8 43.5 78.1 95.4 93 131.1c3.3 7.9 3.3 16.7 0 24.6c-14.9 35.7-46.2 87.7-93 131.1C433.5 443.2 368.8 480 288 480s-145.5-36.8-192.6-80.6C48.6 356 17.3 304 2.5 268.3c-3.3-7.9-3.3-16.7 0-24.6C17.3 208 48.6 156 95.4 112.6zM288 336c44.2 0 80-35.8 80-80s-35.8-80-80-80c-.7 0-1.3 0-2 0c1.3 5.1 2 10.5 2 16c0 35.3-28.7 64-64 64c-5.5 0-10.9-.7-16-2c0 .7 0 1.3 0 2c0 44.2 35.8 80 80 80zm0-208a128 128 0 1 1 0 256 128 128 0 1 1 0-256z"/></svg> --}}
            
			@lang('lang.view')
        </button>
							</div>
							
                            <div class="col-md-6 mb-3">
						
						        <a href="{{asset($editRequest->driving_license)}}" download rel="noopener noreferrer" 
						        target="_blank" class="btn btn-success"> @lang('lang.downloadFile_driving_license')
                                </a>
								<button type="button" class="btn btn-primary"
            onclick="openImageModal('@lang('lang.driving_license')', '{{ asset($editRequest->driving_license) }}')">
			{{-- <svg xmlns="http://www.w3.org/2000/svg" style="width: 16px; " viewBox="0 0 576 512"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path d="M288 80c-65.2 0-118.8 29.6-159.9 67.7C89.6 183.5 63 226 49.4 256c13.6 30 40.2 72.5 78.6 108.3C169.2 402.4 222.8 432 288 432s118.8-29.6 159.9-67.7C486.4 328.5 513 286 526.6 256c-13.6-30-40.2-72.5-78.6-108.3C406.8 109.6 353.2 80 288 80zM95.4 112.6C142.5 68.8 207.2 32 288 32s145.5 36.8 192.6 80.6c46.8 43.5 78.1 95.4 93 131.1c3.3 7.9 3.3 16.7 0 24.6c-14.9 35.7-46.2 87.7-93 131.1C433.5 443.2 368.8 480 288 480s-145.5-36.8-192.6-80.6C48.6 356 17.3 304 2.5 268.3c-3.3-7.9-3.3-16.7 0-24.6C17.3 208 48.6 156 95.4 112.6zM288 336c44.2 0 80-35.8 80-80s-35.8-80-80-80c-.7 0-1.3 0-2 0c1.3 5.1 2 10.5 2 16c0 35.3-28.7 64-64 64c-5.5 0-10.9-.7-16-2c0 .7 0 1.3 0 2c0 44.2 35.8 80 80 80zm0-208a128 128 0 1 1 0 256 128 128 0 1 1 0-256z"/></svg> --}}
			@lang('lang.view')
        </button>
							</div>
							
							<div class="col-md-6 mb-3">
						        <a href="{{asset($editRequest->blood_analysis)}}" download rel="noopener noreferrer" 
						        target="_blank" class="btn btn-success"> @lang('lang.blood_analysis')
                                </a>
								<button type="button" class="btn btn-primary"
							onclick="openImageModal('@lang('lang.blood_analysis')', '{{ asset($editRequest->blood_analysis) }}')">
							{{-- <svg xmlns="http://www.w3.org/2000/svg" style="width: 16px; " viewBox="0 0 576 512"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path d="M288 80c-65.2 0-118.8 29.6-159.9 67.7C89.6 183.5 63 226 49.4 256c13.6 30 40.2 72.5 78.6 108.3C169.2 402.4 222.8 432 288 432s118.8-29.6 159.9-67.7C486.4 328.5 513 286 526.6 256c-13.6-30-40.2-72.5-78.6-108.3C406.8 109.6 353.2 80 288 80zM95.4 112.6C142.5 68.8 207.2 32 288 32s145.5 36.8 192.6 80.6c46.8 43.5 78.1 95.4 93 131.1c3.3 7.9 3.3 16.7 0 24.6c-14.9 35.7-46.2 87.7-93 131.1C433.5 443.2 368.8 480 288 480s-145.5-36.8-192.6-80.6C48.6 356 17.3 304 2.5 268.3c-3.3-7.9-3.3-16.7 0-24.6C17.3 208 48.6 156 95.4 112.6zM288 336c44.2 0 80-35.8 80-80s-35.8-80-80-80c-.7 0-1.3 0-2 0c1.3 5.1 2 10.5 2 16c0 35.3-28.7 64-64 64c-5.5 0-10.9-.7-16-2c0 .7 0 1.3 0 2c0 44.2 35.8 80 80 80zm0-208a128 128 0 1 1 0 256 128 128 0 1 1 0-256z"/></svg> --}}
							@lang('lang.view')
						</button>
							</div>
							
							<div class="col-md-6 mb-3">
						
						        <a href="{{asset($editRequest->criminal_record)}}" download rel="noopener noreferrer" 
						        target="_blank" class="btn btn-success"> @lang('lang.criminal_record')
                                </a>
								<button type="button" class="btn btn-primary"
            onclick="openImageModal('@lang('lang.criminal_record')', '{{ asset($editRequest->criminal_record) }}')">
			{{-- <svg xmlns="http://www.w3.org/2000/svg" style="width: 16px; " viewBox="0 0 576 512"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path d="M288 80c-65.2 0-118.8 29.6-159.9 67.7C89.6 183.5 63 226 49.4 256c13.6 30 40.2 72.5 78.6 108.3C169.2 402.4 222.8 432 288 432s118.8-29.6 159.9-67.7C486.4 328.5 513 286 526.6 256c-13.6-30-40.2-72.5-78.6-108.3C406.8 109.6 353.2 80 288 80zM95.4 112.6C142.5 68.8 207.2 32 288 32s145.5 36.8 192.6 80.6c46.8 43.5 78.1 95.4 93 131.1c3.3 7.9 3.3 16.7 0 24.6c-14.9 35.7-46.2 87.7-93 131.1C433.5 443.2 368.8 480 288 480s-145.5-36.8-192.6-80.6C48.6 356 17.3 304 2.5 268.3c-3.3-7.9-3.3-16.7 0-24.6C17.3 208 48.6 156 95.4 112.6zM288 336c44.2 0 80-35.8 80-80s-35.8-80-80-80c-.7 0-1.3 0-2 0c1.3 5.1 2 10.5 2 16c0 35.3-28.7 64-64 64c-5.5 0-10.9-.7-16-2c0 .7 0 1.3 0 2c0 44.2 35.8 80 80 80zm0-208a128 128 0 1 1 0 256 128 128 0 1 1 0-256z"/></svg> --}}
			@lang('lang.view')
        </button>
							</div>
                        </div>

						
						<div class="modal fade" id="imageModal" tabindex="-1" aria-labelledby="imageModalLabel" aria-hidden="true">
							<div class="modal-dialog modal-dialog-centered">
								<div class="modal-content">
									<div class="modal-header">
										<h5 class="modal-title" id="imageModalLabel"></h5>
										<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
									</div>
									<div class="modal-body text-center">
										<img id="modalImage" src="" class="img-fluid rounded" alt="">
									</div>
								</div>
							</div>
						</div>
                      
						
				
				</div>
			</div>
			
		
		</div>
	</div>
</div>


<!-- Rejection Reason Modal -->
<div class="modal fade" id="rejectionReasonModal" tabindex="-1" aria-labelledby="rejectionReasonLabel" aria-hidden="true">
	<div class="modal-dialog">
	  <div class="modal-content">
		<div class="modal-header">
		  <h5 class="modal-title" id="rejectionReasonLabel">@lang('lang.rejection_reason')</h5>
		  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
		</div>
		<div class="modal-body">
		  <form id="rejectionForm" method="POST" action="{{ route('admin.edit_requests.update', $editRequest->id) }}">
			@csrf
			@method('PUT')
			<input type="hidden" name="action" value="reject">
			<div class="mb-3">
			  <label for="rejection_reason" class="form-label">@lang('lang.please_provide_reason')</label>
			  <textarea class="form-control" id="rejection_reason" name="rejection_reason" required></textarea>
			</div>
		  </form>
		</div>
		<div class="modal-footer">
		  <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">@lang('lang.cancel')</button>
		  <button type="button" class="btn btn-danger" id="confirmReject">@lang('lang.reject')</button>
		</div>
	  </div>
	</div>
  </div>
  
@endsection

@section('script')

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Show modal when the Reject button is clicked
        document.querySelector('.reject-button').addEventListener('click', function() {
            var rejectionModal = new bootstrap.Modal(document.getElementById('rejectionReasonModal'));
            rejectionModal.show();
        });

        // Handle modal confirmation button
        document.getElementById('confirmReject').addEventListener('click', function() {
            document.getElementById('rejectionForm').submit();
        });
    });
</script>


<script>
    function openImageModal(title, imagePath) {
        // Set modal title
        document.getElementById('imageModalLabel').innerText = title;

        // Set image source
        document.getElementById('modalImage').src = imagePath;

        // Open the modal
        var imageModal = new bootstrap.Modal(document.getElementById('imageModal'));
        imageModal.show();
    }
</script>


<script src="{{asset('assets/js/select2/select2.full.min.js')}}"></script>
<script src="{{asset('assets/js/select2/select2-custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>
@endsection