@extends('admin.layout.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/select2.css')}}">

@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3> @lang('lang.edits_request')</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item"> @lang('lang.Dashboard')</li>
<li class="breadcrumb-item active">@lang('lang.edits_request')</li>
@endsection

@section('content')
<div class="container-fluid">
    
		<div class="row">
		<div class="col-sm-12 mt-3">
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
						<table class="" id="advance-1">
							<thead>
								<tr>
									<tr>
                                        <th>@lang('lang.Name')</th>
									    <th class="text-center">@lang('lang.Status')</th>
									    <th>@lang('lang.date')</th>
                                        <th></th>								
                                    </tr>
								</tr>
							</thead>
							<tbody>
                                @foreach ($requests as $item)
                                    
                                
                                <tr>
                                    <td>{{ $item?->user?->name }}</td>
                                    
                                    
                                    {{-- <td class="text-center">{{ $item?->request_status}}</td> --}}
                                    @if ($item?->request_status =="approved")
                                    <td style="pointer-events: none; cursor: not-allowed;" class="badge badge-success text-center">
                                        @lang('lang.approved')
                                    </td>
                                    @elseif($item?->request_status =="rejected")
                                    <td style="pointer-events: none; cursor: not-allowed;" class="badge badge-danger text-center">
                                        @lang('lang.rejected')	
                                    </td>
                                    @elseif($item?->request_status =="pending")
                                    <td style="pointer-events: none; cursor: not-allowed;"class="badge badge-warning text-center">
                                        @lang('lang.pending')	
                                    </td>
                                        @endif
                                        
                                    
                                    {{-- <td>{{ $item?->created_at->format('Y-m-d') }}</td> --}}
                                    <td>{{ $item?->created_at }}</td>
                                   
                                    <td><form action="{{ route('admin.edit_requests.update', $item->id) }}" method="POST">
                                        @csrf
                                        @method('PUT')
                                    
                                        <button type="submit"  name="action" value="approve" class="btn btn-success">@lang('lang.approve')	</button>
                                        {{-- <button type="submit" {{$item?->request_status =="approved" ? 'disabled' : ''}} name="action" value="reject" class="btn btn-danger">@lang('lang.reject')	</button> --}}

										<button type="button" {{$item?->request_status =="approved" ? 'disabled' : ''}} 
											class="btn btn-danger reject-button" 
											data-id="{{ $item->id }}">@lang('lang.reject')</button>
									

                                    </form>
									<a href="{{route('admin.edit_requests.details',$item?->id)}}" class="btn btn-primary">@lang('lang.details')	</a>
                                </td>
								@endforeach
								
							</tbody>
							<tfoot>
								<tr>
									<th>@lang('lang.Name')</th>
									<th class="text-center">@lang('lang.Status')</th>
									<th>@lang('lang.date')</th>
									<th></th>								
								</tr>							
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	
	</div>
</div>


<!-- Rejection Reason Modal -->
<div class="modal fade" id="rejectionReasonModal" tabindex="-1" aria-labelledby="rejectionReasonLabel" aria-hidden="true">
	<div class="modal-dialog">
	  <div class="modal-content">
		<div class="modal-header">
		  <h5 class="modal-title" id="rejectionReasonLabel">@lang('lang.rejection_reason')</h5>
		  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
		</div>
		<div class="modal-body">
		  <form id="rejectionForm"  method="POST">
			@csrf
			@method('PUT')
			<input type="hidden" id="rejectRequestId" name="request_id">
			<div class="mb-3">
			  <label for="rejection_reason" class="form-label">@lang('lang.please_provide_reason')</label>
			  <textarea class="form-control" id="rejection_reason" name="rejection_reason" required></textarea>
			</div>
		  </form>
		</div>
		<div class="modal-footer">
		  <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">@lang('lang.cancel')</button>
		  <button type="button" class="btn btn-danger" id="confirmReject">@lang('lang.reject')</button>
		</div>
	  </div>
	</div>
  </div>
  



@endsection


@section('script')
<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<!--<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>-->
<!--<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>-->
<!--<script src="{{asset('assets/js/select2/select2.full.min.js')}}"></script>-->
<!--<script src="{{asset('assets/js/select2/select2-custom.js')}}"></script>-->
<!--<script src="{{asset('assets/js/sweet-alert/sweetalert.min.js')}}"></script>-->
<!--<script src="{{asset('assets/js/sweet-alert/app.js')}}"></script>-->

<script>
    $(document).ready(function() {
        // Show modal when Reject button is clicked
        $('.reject-button').on('click', function() {
            var requestId = $(this).data('id');
            $('#rejectRequestId').val(requestId);  // Set the request ID in the hidden input
            $('#rejectionReasonModal').modal('show');  // Show the modal
        });

        // Handle modal confirmation button
        $('#confirmReject').on('click', function() {
            var form = $('#rejectionForm');
            // form.attr('action', 'dashboard/edit_requests/' + $('#rejectRequestId').val());
			form.attr('action', '{{ route("admin.edit_requests.update", ":id") }}'.replace(':id', $('#rejectRequestId').val()));

            form.submit();  // Submit the form
        });
    });
</script>

<script>

	function getRecord(data){
	    document.getElementById("section_name_ar").value=data['name_ar'];
	    document.getElementById("section_name_en").value=data['name_en'];
	    document.getElementById("section_id").value=data['id'];
   }

   function getId(id){
	    document.getElementById("notification_id").value=id;
   }
</script>

    <script src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
	<script>
		$(document).ready(function() {
			$('#advance-1').DataTable( {
			    select: true,
					
					"columnDefs": [
						{
							className: "Name", 
				// 			"targets":[0],
							"visible": true,
							"searchable":true
						},
						
						{ "orderable": false, "targets": [0,1,2,3,5] }
						
						],
					"order": [[ 0 ]],
					"pageLength": 5, // Set the number of records per page

				initComplete: function () {
				    
					this.api().columns([0,1,2,3,5]).every( function () {
						
						var column = this;
						var select = $("<select class='js-example-placeholder-multiple col-sm-12'><option value=''></option></select>")
							.appendTo( $(column.header()).empty() )
							.on( 'change', function () {
								var val = $.fn.dataTable.util.escapeRegex(
									$(this).val()
								);
		
								column
									.search( val ? '^'+val+'$' : '', true, false )
									.draw();
							} );
		
						column.data().unique().sort().each( function ( d, j ) {
							select.append( '<option value="'+d+'">'+d+'</option>' )
						} );
					} );
				}
			} );
		} );
	</script>
  <script src="{{asset('assets/js/select2/select2.full.min.js')}}"></script>
<script src="{{asset('assets/js/select2/select2-custom.js')}}"></script>
@endsection


