@extends('admin.layout.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/select2.css')}}">

@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3> @lang('lang.Rides')</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item"> @lang('lang.Dashboard')</li>
<li class="breadcrumb-item active">@lang('lang.Rides')</li>
@endsection

@section('content')
<div class="container-fluid">
   
		<div class="row">
		<div class="col-sm-12 mt-3">
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
						<table class="" id="advance-1">
							<div style="position: relative ;height: 50px;">
								<a style="position: absolute;left:0 ; "href="{{route('admin.export.rides', $rideId)}}" >
								
									<svg xmlns="http://www.w3.org/2000/svg" style="width: 20px;" viewBox="0 0 576 512"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path d="M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 128-168 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l168 0 0 112c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM384 336l0-48 110.1 0-39-39c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l80 80c9.4 9.4 9.4 24.6 0 33.9l-80 80c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l39-39L384 336zm0-208l-128 0L256 0 384 128z"/></svg>
								</a>
							</div>
							<thead>
								<tr>
									<th>@lang('lang.Name')</th>
									<th>@lang('lang.longitude')</th>
									<th>@lang('lang.latitude')</th>
									<th>@lang('lang.point')</th>
									<th>@lang('lang.Time')</th>
									<th>@lang('lang.maps')</th>
								</tr>
							</thead>
							<tbody>

								@foreach($rideDetails as $ride)
								
								
								 
									<tr>
										<td>
                                            {{$ride?->name  }}
                                            {{-- {{$ride?->lang }} --}}
                                        </td>
										<td>
                                            {{$ride?->lang }}
                                        </td>
										<td>
                                            {{$ride?->lat }}
                                        </td>
										<td>

											@if ($ride?->is_start_point == 1)
													@lang('lang.start_point')
												
											@elseif ($ride?->is_end_point == 1)
												@lang('lang.end_point')
											@endif
                                            {{-- {{$ride?->lat }} --}}
                                        </td>
										<td>
                                            {{$ride?->created_at }}
                                        </td>
										
										<td>
											<a class="btn btn-primary" href="https://www.google.com/maps?q={{ $ride?->lat }},{{ $ride?->lang }}" target="_blank">
												<i style="font-size: 25px" class="fa fa-map-marker"></i>
													{{-- @lang('lang.open_map') --}}
											</a>
											
										
										
									</tr>
								{{-- @empty --}}
								@endforeach

								{{-- @endforelse --}}
								
							</tbody>
							<tfoot>
								<tr>
									<th>@lang('lang.Name')</th>
									<th>@lang('lang.longitude')</th>
									<th>@lang('lang.latitude')</th>
									<th>@lang('lang.point')</th>
									<th>@lang('lang.Time')</th>
									<th>@lang('lang.maps')</th>
								</tr>							
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	
	</div>
</div>




@endsection


@section('script')
<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<!--<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>-->
<!--<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>-->
<!--<script src="{{asset('assets/js/select2/select2.full.min.js')}}"></script>-->
<!--<script src="{{asset('assets/js/select2/select2-custom.js')}}"></script>-->
<!--<script src="{{asset('assets/js/sweet-alert/sweetalert.min.js')}}"></script>-->
<!--<script src="{{asset('assets/js/sweet-alert/app.js')}}"></script>-->

<script>

	function getRecord(data){
	    document.getElementById("section_name_ar").value=data['name_ar'];
	    document.getElementById("section_name_en").value=data['name_en'];
	    document.getElementById("section_id").value=data['id'];
   }
   
   function getId(id){
	    document.getElementById("notification_id").value=id;
   }
</script>

    <script src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
	<script>
		$(document).ready(function() {
			$('#advance-1').DataTable( {
			    select: true,
					
					"columnDefs": [
						{
							className: "Name", 
				// 			"targets":[0],
							"visible": true,
							"searchable":true
						},
						
						{ "orderable": false, "targets": [0,1,2,3,5] }
						
						],
					"order": [[ 0 ]],
					"pageLength": 5, // Set the number of records per page

				initComplete: function () {
				    
					this.api().columns([0,1,2,3,5]).every( function () {
						
						var column = this;
						var select = $("<select class='js-example-placeholder-multiple col-sm-12'><option value=''></option></select>")
							.appendTo( $(column.header()).empty() )
							.on( 'change', function () {
								var val = $.fn.dataTable.util.escapeRegex(
									$(this).val()
								);
		
								column
									.search( val ? '^'+val+'$' : '', true, false )
									.draw();
							} );
		
						column.data().unique().sort().each( function ( d, j ) {
							select.append( '<option value="'+d+'">'+d+'</option>' )
						} );
					} );
				}
			} );
		} );
	</script>
  <script src="{{asset('assets/js/select2/select2.full.min.js')}}"></script>
<script src="{{asset('assets/js/select2/select2-custom.js')}}"></script>
@endsection


