@extends('admin.layout.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/select2.css')}}">

@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3> @lang('lang.Rides')</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item"> @lang('lang.Dashboard')</li>
<li class="breadcrumb-item active">@lang('lang.Rides')</li>
@endsection

@section('content')
<div class="container-fluid">
    	<form class="needs-validation" novalidate="" method="GET" action="{{ route('rides.index') }}">
                        @csrf
	<div class="row">
							
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">تاريخ البداية</label>
								<input class="form-control" id="validationCustom01" type="datetime-local" name="start_date" value="{{ old('start_date',$_GET['start_date'] ??"") }}" placeholder="title" required="">
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a title.</div>

							</div>
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">تاريخ النهاية</label>
								<input class="form-control" id="validationCustom01" type="datetime-local" name="end_date" value="{{ old('end_date',$_GET['end_date']?? "") }}" placeholder="title" required="">
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a title.</div>

							</div>
							
						</div>
						<center>
												<button class="btn btn-primary" type="submit">@lang('lang.search')</button>
												    <input class="btn btn-secondary" type="reset" value="@lang('lang.reset')">

                        </center>

</form>
		<div class="row">
		<div class="col-sm-12 mt-3">
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
						<table class="" id="advance-1">
							<div style="position: relative; height: 50px;">
								<a id="ride-export-button" style="position: absolute; left: 0;" href="#" onclick="exportRideDrivers()">
									<svg xmlns="http://www.w3.org/2000/svg" style="width: 20px;" viewBox="0 0 576 512">
										<path d="M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 128-168 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l168 0 0 112c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM384 336l0-48 110.1 0-39-39c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l80 80c9.4 9.4 9.4 24.6 0 33.9l-80 80c9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l39-39L384 336zm0-208l-128 0L256 0 384 128z"/>
									</svg>
								</a>
							</div>
							
							<thead>
								<tr>
									<th>@lang('lang.clienName')</th>
									<th>@lang('lang.clienPhone')</th>
									<th>@lang('lang.Name')</th>
									<th>@lang('lang.phone')</th>
									<th>@lang('lang.date')</th>
									<th>@lang('lang.actual_price')</th>
									<th>@lang('lang.actual_distance')</th>
									<th>@lang('lang.status')</th>
									<th>@lang('lang.startPoint')</th>
									<th>@lang('lang.endPoint')</th>
									<th>@lang('lang.details')</th>
								</tr>
							</thead>
							<tbody>
								@if ($result)
									
								
								@forelse ($result as $item)
									<tr>
										<td>
                                            {{$item?->client?->name }}
                                        </td>
										<td>
                                            {{$item?->client?->phone }}
                                        </td>
										<td>
                                            {{$item?->user?->name }}
                                        </td>
					
										<td>
                                            {{$item?->user?->phone }}
                                        </td>
					
										<td>{{ $item->created_at  }}</td>

										<td>{{ $item->actual_price  }}</td>

										<td>{{ $item->actual_distance  }}</td>
																			
	                                       <td class="text-center">
											@if ($item->status ==1)
											@lang('lang.complete')
											@else
											@lang('lang.active')	
											@endif
											
										</td>                                       
										<td>{{ $item->startPoint->name??""  }}</td>
			
                                        <td>
                                            @foreach ($item->endPoints as $point)
                                                <span>{{ $point->name??"" }}</span>
                                                <br>
												<span>{{ "------------------------------" }}</span>
                                            @endforeach
                                        </td>
										<td>
											{{-- <button class="btn btn-primary">  
												<a href="https://www.google.com/maps?q={{ $latitude }},{{ $longitude }}" target="_blank">
													@lang('lang.open_map')
											</a>
											</button> --}}
										
											<a  class="btn btn-primary" href="{{route('rides.details',($item->id))}}" >
												@lang('lang.details')
											</a>
										
									</tr>
								@empty
									

								@endforelse
								@endif
								
							</tbody>
							<tfoot>
								<tr>
									<th>@lang('lang.clientName')</th>
									<th>@lang('lang.clientPhone')</th>
									<th>@lang('lang.Name')</th>
									<th>@lang('lang.phone')</th>
									<th>@lang('lang.date')</th>
									<th>@lang('lang.actual_price')</th>
									<th>@lang('lang.actual_distance')</th>
									<th>@lang('lang.status')</th>
                                    <th>@lang('lang.startPoint')</th>
                                    <th>@lang('lang.endPoint')</th>
                                    <th>@lang('lang.details')</th>
								</tr>							
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	
	</div>
</div>




@endsection


@section('script')
<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<!--<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>-->
<!--<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>-->
<!--<script src="{{asset('assets/js/select2/select2.full.min.js')}}"></script>-->
<!--<script src="{{asset('assets/js/select2/select2-custom.js')}}"></script>-->
<!--<script src="{{asset('assets/js/sweet-alert/sweetalert.min.js')}}"></script>-->
<!--<script src="{{asset('assets/js/sweet-alert/app.js')}}"></script>-->


<script>
	function exportRideDrivers() {
    // Get selected start and end date values
    let startDate = document.querySelector('input[name="start_date"]').value;
    let endDate = document.querySelector('input[name="end_date"]').value;

    // Get search input value from DataTable
    let searchValue = $('#advance-1_filter input').val(); // Capture search input

    // Construct the export URL with query parameters
    let exportUrl = "{{ route('admin.export.rideDrivers') }}";

    // Append query parameters if they exist
    let params = [];
    if (startDate) params.push(`start_date=${startDate}`);
    if (endDate) params.push(`end_date=${endDate}`);
    if (searchValue) params.push(`search=${searchValue}`);

    if (params.length > 0) {
        exportUrl += `?${params.join('&')}`;
    }

    // Redirect to the export URL
    window.location.href = exportUrl;
}

</script>


<script>

	function getRecord(data){
	    document.getElementById("section_name_ar").value=data['name_ar'];
	    document.getElementById("section_name_en").value=data['name_en'];
	    document.getElementById("section_id").value=data['id'];
   }
   
   function getId(id){
	    document.getElementById("notification_id").value=id;
   }
</script>

    <script src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
	<script>
		$(document).ready(function() {
			$('#advance-1').DataTable( {
			    select: true,
					
					"columnDefs": [
						{
							className: "Name", 
				// 			"targets":[0],
							"visible": true,
							"searchable":true
						},
						
						{ "orderable": false, "targets": [0,1,2,3,5] }
						
						],
					"order": [[ 0 ]],
					"pageLength": 5, // Set the number of records per page

				initComplete: function () {
				    
					this.api().columns([0,1,2,3,5]).every( function () {
						
						var column = this;
						var select = $("<select class='js-example-placeholder-multiple col-sm-12'><option value=''></option></select>")
							.appendTo( $(column.header()).empty() )
							.on( 'change', function () {
								var val = $.fn.dataTable.util.escapeRegex(
									$(this).val()
								);
		
								column
									.search( val ? '^'+val+'$' : '', true, false )
									.draw();
							} );
		
						column.data().unique().sort().each( function ( d, j ) {
							select.append( '<option value="'+d+'">'+d+'</option>' )
						} );
					} );
				}
			} );
		} );
	</script>
	
	<script>
		$(document).ready(function () {
			let table = $('#advance-1').DataTable(); // Initialize DataTable once
	
			$('input[type="reset"]').on('click', function (e) {
				e.preventDefault(); // Prevent default form reset behavior
	
				// Reset filter inputs
				$('input[name="start_date"]').val('');
				$('input[name="end_date"]').val('');

				// Clear all filters in DataTable
				table.search('').columns().search('').draw();
				// Clear all filters in DataTable
				table.clear().draw(); // This removes all data from the table
			});
		});
	</script>
	
	
  <script src="{{asset('assets/js/select2/select2.full.min.js')}}"></script>
<script src="{{asset('assets/js/select2/select2-custom.js')}}"></script>
@endsection


