@extends('admin.layout.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/select2.css')}}">

@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3> @lang('lang.rides_bonus')</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item"> @lang('lang.Dashboard')</li>
<li class="breadcrumb-item active"> @lang('lang.rides_bonus')</li>
@endsection

@section('content')
<div class="container-fluid">
	{{-- @if($errors->any())
    {!! implode('', $errors->all('<span class="text text-danger">:message</span>')) !!}
@endif --}}
@error('city')

 <div class="alert alert-danger dark alert-dismissible fade show" role="alert">
	<strong>{{ $message }} </strong>
 <button class="btn-close" type="button" data-bs-dismiss="alert" aria-label="Close"></button>    </div>
							    @enderror
		<div class="row">
			<div class="d-flex justify-content-end col-sm-12">
				<button class="btn btn-primary" type="button" data-bs-toggle="modal" data-original-title="test" data-bs-target="#addModal" >@lang('lang.add')</button>
			</div>
		
		<div class="col-sm-12 mt-3">
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
						<table class="display text-center" id="advance-1">
							<div style="position: relative ;height: 50px;">
								<a style="position: absolute;left:0 ; "href="{{route('ride_bonus.export')}}" >
								
									<svg xmlns="http://www.w3.org/2000/svg" style="width: 20px;" viewBox="0 0 576 512"><!--!Font Awesome Free 6.7.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2025 Fonticons, Inc.--><path d="M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 128-168 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l168 0 0 112c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM384 336l0-48 110.1 0-39-39c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l80 80c9.4 9.4 9.4 24.6 0 33.9l-80 80c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l39-39L384 336zm0-208l-128 0L256 0 384 128z"/></svg>
								</a>
							</div>
							<thead>
								<tr>
									<th>@lang('lang.number')</th>
									<th>@lang('lang.Name')</th>
									<th>@lang('lang.description')</th>
									<th>@lang('lang.bonus_type')</th>
									<th>@lang('lang.bonus_value')</th>
									<th>@lang('lang.type')</th>
									<th class="text-center">@lang('lang.Status')</th>
									<th>@lang('lang.time_from')</th>
									<th>@lang('lang.time_to')</th>
									<th></th>								
									{{-- <th>@lang('lang.Status')</th> --}}
									{{-- <th>@lang('lang.date')</th> --}}
								</tr>
							</thead>
							<tbody>
							    @foreach ($ridesBonus as $item)
                                <tr>
                                    <td>{{ $item?->rides_number }}</td>
                                    <td>{{ $item?->bonus_name }}</td>
                                    <td>{{ $item?->description }}</td>
                                    {{-- <td>{{ $item?->bonus_type }}</td> --}}
									<td>@lang("lang.{$item?->bonus_type}")</td>
									
                                    <td>{{ $item?->bonus_value }}</td>
                                    <td>@lang("lang.{$item?->type}")</td>
                                    
                                    
                                    {{-- <td class="text-center">{{ $item?->request_status}}</td> --}}
									<td class="text-center">
										@if ($item?->enable == "1")
											<span class="badge badge-success p-2 fs-6">@lang('lang.enable')</span>
										@elseif ($item?->enable == "0")
											<span class="badge badge-danger p-2 fs-6">@lang('lang.disable')</span>
										@endif
									</td>
                                        
                                    
                                    {{-- <td>{{ $item?->created_at->format('Y-m-d') }}</td> --}}
									<td>{{ $item?->time_from }}</td>
                                    <td>{{ $item?->time_to }}</td>
                                
                                    
									<td>
										<button class="btn m-1 btn-primary" type="button" data-bs-toggle="modal" data-original-title="test" data-bs-target="#exampleModal"  onclick="getRecord({{ $item }})">@lang('lang.edit')</button>
										<form action="{{ route('admin.riders_bonus.changeEnable') }}" method="POST">
											
											@csrf
											<input type="hidden" name="id" value="{{$item->id}}" id="notification_id">
											
											<button class="btn m-1 btn-secondary" type="submit" >@lang('lang.changeEnable')</button>
											
											
										</form>
										<a class="btn m-1 btn-info" href="{{route('admin.riders_bonus.logs',$item->id)}}">@lang('lang.logs')</a>
									</td>
									
								</tr>							
								
								@endforeach
								
							</tbody>
							<tfoot>
								<tr>
									<th>@lang('lang.number')</th>
									<th>@lang('lang.Name')</th>
									<th>@lang('lang.description')</th>
									<th>@lang('lang.bonus_type')</th>
									<th>@lang('lang.bonus_value')</th>
									<th>@lang('lang.type')</th>
									<th class="text-center">@lang('lang.Status')</th>
									<th>@lang('lang.time_from')</th>
									<th>@lang('lang.time_to')</th>
									<th></th>								
									{{-- <th>@lang('lang.Status')</th> --}}
									{{-- <th>@lang('lang.date')</th> --}}
								</tr>							
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	
	</div>
</div>


<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalLabel" aria-hidden="true">

	<div class="modal-dialog" role="document">
	   <div class="modal-content">
		  <div class="modal-header">
			 <h5 class="modal-title" id="addModalLabel">@lang('lang.add')</h5>
			 <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
		  </div>
		  <div class="modal-body">

			<form class="needs-validation" novalidate="" method="POST" enctype="multipart/form-data" action="{{ route('admin.riders_bonus.store') }}">
				@csrf
				<div class="row">

					<div class="col-md-12 mb-3">
						<label for="bonus_name">@lang('lang.Name')</label>
						<input class="form-control" id="bonus_name" type="text" name="bonus_name" value="" placeholder="@lang('lang.enter_bonus_name')" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please enter a bonus name.</div>
					</div>

					<div class="col-md-12 mb-3">
						<label for="description">@lang('lang.description')</label>
						<input class="form-control" id="description" type="text" name="description" value="" placeholder="@lang('lang.enter_description')" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please enter a description.</div>
					</div>

					<div class="col-md-12 mb-3">
						<label for="type">@lang('lang.type')</label>
						<select class="form-control" name="type" required="">
							<option value="" disabled selected>@lang('lang.select_type')</option>
							<option value="daily">@lang('lang.daily')</option>
							<option value="weekly">@lang('lang.weekly')</option>
							<option value="monthly">@lang('lang.monthly')</option>
						</select>
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a bonus type.</div>
					</div>
					<div class="col-md-12 mb-3">
						<label for="bonus_type">@lang('lang.bonus_type')</label>
						<select class="form-control" name="bonus_type" required="">
							<option value="" disabled selected>@lang('lang.select_bonus_type')</option>
							<option value="money">@lang('lang.money')</option>
							<option value="percentage">@lang('lang.percentage')</option>
						</select>
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a bonus type.</div>
					</div>

					<div class="col-md-12 mb-3">
						<label for="bonus_value">@lang('lang.bonus_value')</label>
						<input class="form-control" id="bonus_value" type="number" name="bonus_value" value="" placeholder="@lang('lang.enter_bonus_value')" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please enter a bonus value.</div>
					</div>

					<div class="col-md-12 mb-3">
						<label for="time_from">@lang('lang.time_from')</label>
						<input class="form-control" id="time_from"  type="datetime-local" name="time_from" value="" placeholder="time from" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a time from.</div>
					</div>
					<div class="col-md-12 mb-3">
						<label for="time_to">@lang('lang.time_to')</label>
						<input class="form-control" id="time_to" type="datetime-local" name="time_to" value="" placeholder="time to" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a time to.</div>
					</div>
				
				</div>
				
				<div class="modal-footer">
					<button class="btn btn-primary" type="button" data-bs-dismiss="modal">@lang('lang.close')</button>
					<button class="btn btn-secondary" type="submit">@lang('lang.save')</button>
				 </div>
			</form>

		  </div>
		  
	   </div>
	</div>
</div>

<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">

	<div class="modal-dialog" role="document">
	   <div class="modal-content">
		  <div class="modal-header">
			 <h5 class="modal-title" id="exampleModalLabel">@lang('lang.edit')</h5>
			 <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
		  </div>
		  <div class="modal-body">

			<form class="needs-validation" novalidate="" method="POST" enctype="multipart/form-data" action="{{ route('admin.riders_bonus.update') }}">
				@csrf
				<input type="hidden" id="section_id" name="id">
				<div class="row">

					<div class="col-md-12 mb-3">
						<label for="section_bonus_name">@lang('lang.Name')</label>
						<input class="form-control" id="section_bonus_name" type="text" name="bonus_name" value="" placeholder="@lang('lang.enter_bonus_name')" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please enter a bonus name.</div>
					</div>
					<div class="col-md-12 mb-3">
						<label for="section_description">@lang('lang.description')</label>
						<input class="form-control" id="section_description" type="text" name="description" value="" placeholder="@lang('lang.enter_description')" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please enter a bonus name.</div>
					</div>

					<div class="col-md-12 mb-3">
						<label for="section_type">@lang('lang.type')</label>
						<select class="form-control" id="section_type" name="type" required="">
							<option value="" disabled selected>@lang('lang.select_type')</option>
							<option value="daily">@lang('lang.daily')</option>
							<option value="weekly">@lang('lang.weekly')</option>
							<option value="monthly">@lang('lang.monthly')</option>
						</select>
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a bonus type.</div>
					</div>
					<div class="col-md-12 mb-3">
						<label for="section_bonus_type">@lang('lang.bonus_type')</label>
						<select class="form-control" id="section_bonus_type" name="bonus_type" required="">
							<option value="" disabled selected>@lang('lang.select_bonus_type')</option>
							<option value="money">@lang('lang.money')</option>
							<option value="percentage">@lang('lang.percentage')</option>
						</select>
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a bonus type.</div>
					</div>

					<div class="col-md-12 mb-3">
						<label for="section_bonus_value">@lang('lang.bonus_value')</label>
						<input class="form-control" id="section_bonus_value" type="number" name="bonus_value" value="" placeholder="@lang('lang.enter_bonus_value')" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please enter a bonus value.</div>
					</div>

					<div class="col-md-12 mb-3">
						<label for="section_time_from">@lang('lang.time_from')</label>
						<input class="form-control" id="section_time_from" type="datetime-local" name="time_from" value="" placeholder="time from" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a time from.</div>
					</div>
					<div class="col-md-12 mb-3">
						<label for="section_time_to">@lang('lang.time_to')</label>
						<input class="form-control" id="section_time_to" type="datetime-local" name="time_to" value="" placeholder="time to" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a time to.</div>
					</div>
				
				</div>
				
				<div class="modal-footer">
					<button class="btn btn-primary" type="button" data-bs-dismiss="modal">@lang('lang.close')</button>
					<button class="btn btn-secondary" type="submit">@lang('lang.edit')</button>
				 </div>
			</form>

		  </div>
		  
	   </div>
	</div>
</div>

@endsection


@section('script')
<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>
<script src="{{asset('assets/js/select2/select2.full.min.js')}}"></script>
<script src="{{asset('assets/js/select2/select2-custom.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/sweetalert.min.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/app.js')}}"></script>

{{-- <script>
	document.addEventListener('DOMContentLoaded', function () {
		const bonusTypeSelect = document.querySelector('select[name="bonus_type"]');
		const bonusValueInput = document.querySelector('input[name="bonus_value"]');
		const timeToInput = document.querySelector('input[name="time_to"]');

		bonusValueInput.disabled = true;

		bonusTypeSelect.addEventListener('change', function () {
			bonusValueInput.disabled = false;
			if (this.value === 'percentage') {
				bonusValueInput.max = 100;
			} else {
				bonusValueInput.removeAttribute('max');
			}
		});

		const today = new Date().toISOString().split('T')[0];
		timeToInput.setAttribute('min', today);
	});

	function getRecord(data){
		document.getElementById("section_id").value=data['id'];
	    document.getElementById("section_bonus_name").value=data['bonus_name'];
	    document.getElementById("section_description").value=data['description'];
	    document.getElementById("section_type").value=data['type'];
	    document.getElementById("section_bonus_type").value=data['bonus_type'];
	    document.getElementById("section_bonus_value").value=data['bonus_value'];
	    document.getElementById("section_time_from").value=data['time_from'];
	    document.getElementById("section_time_to").value=data['time_to'];
   }
   
   function getId(id){
	    document.getElementById("notification_id").value=id;
   }
</script> --}}

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const bonusTypeSelect = document.querySelector('select[name="bonus_type"]');
        const bonusValueInput = document.querySelector('input[name="bonus_value"]');

        bonusValueInput.disabled = true;

        bonusTypeSelect.addEventListener('change', function () {
            bonusValueInput.disabled = false;
            if (this.value === 'percentage') {
                bonusValueInput.setAttribute('min', '1');
                bonusValueInput.setAttribute('max', '100');
            } else {
                bonusValueInput.removeAttribute('min');
                bonusValueInput.removeAttribute('max');
            }
        });

        bonusValueInput.addEventListener('input', function () {
            if (bonusTypeSelect.value === 'percentage') {
                let value = parseInt(this.value);
                if (value < 1) {
                    this.value = 1;
                } else if (value > 100) {
                    this.value = 100;
                }
            }
        });

    });

    function getRecord(data){
        document.getElementById("section_id").value = data['id'];
        document.getElementById("section_bonus_name").value = data['bonus_name'];
        document.getElementById("section_description").value = data['description'];
        document.getElementById("section_type").value = data['type'];
        document.getElementById("section_bonus_type").value = data['bonus_type'];
        document.getElementById("section_bonus_value").value = data['bonus_value'];
        document.getElementById("section_time_from").value = data['time_from'];
        document.getElementById("section_time_to").value = data['time_to'];
    }
   
    function getId(id){
        document.getElementById("notification_id").value = id;
    }
</script>

@endsection