@extends('admin.layout.master')
@section('title', 'Bootstrap Basic Tables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/select2.css')}}">

<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">
@endsection




@section('style')
@endsection

@section('breadcrumb-title')
<h3>@lang('lang.logs')</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">@lang('lang.Orders')</li>
<li class="breadcrumb-item active">@lang('lang.order_details')</li>
@endsection

@section('content')
<div class="container-fluid">



	<div class="row">
		<div class="col-sm-12 mt-3">
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
						<table class="display" id="advance-1">
							<thead>
								<tr>
										<th scope="col">#</th>
								<th scope="col">@lang('lang.Name')</th>
								{{-- <th class="text-center">@lang('lang.quantity')</th> --}}
                                <th class="text-center">@lang('lang.rides_bonus')</th>
								
								</tr>
							</thead>
							<tbody>
								@forelse ($driverRidesBonusLog as $item)
								<tr>
                                    <th scope="row">{{$loop->iteration}}</th>
                                    {{-- <td>{{ $item->id }}</td> --}}
                                    {{-- <td class="text-center">{{ $item->id }}</td> --}}
                                    <td class="text-center">{{ $item?->rideDriver?->user?->name }}</td>
                                    <td class="text-center">{{ $item->id_rides_bonus }}</td>
                                </tr> 
								@empty
									
								@endforelse
								
							</tbody>
							<tfoot>
								<tr>
										<th scope="col">#</th>
								<th scope="col">@lang('lang.Name')</th>
								{{-- <th class="text-center">@lang('lang.quantity')</th> --}}
                                <th class="text-center">@lang('lang.rides_bonus')</th>
								
								</tr>							
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	
	</div>



</div>
@endsection

@section('script')


<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>
<script src="{{asset('assets/js/select2/select2.full.min.js')}}"></script>
<script src="{{asset('assets/js/select2/select2-custom.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/sweetalert.min.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/app.js')}}"></script>
@endsection