@extends('admin.layout.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/select2.css')}}">

@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3> @lang('lang.tolls')</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item"> @lang('lang.Dashboard')</li>
<li class="breadcrumb-item active"> @lang('lang.tolls')</li>
@endsection

@section('content')
<div class="container-fluid">
	{{-- @if($errors->any())
    {!! implode('', $errors->all('<span class="text text-danger">:message</span>')) !!}
@endif --}}
@error('city')

 <div class="alert alert-danger dark alert-dismissible fade show" role="alert"><strong>{{ $message }} </strong>
 <button class="btn-close" type="button" data-bs-dismiss="alert" aria-label="Close"></button>    </div>
							    	@enderror
		<div class="row">
			<div class="d-flex justify-content-end col-sm-12">
		{{-- <button class="btn btn-primary" type="button" data-bs-toggle="modal" data-original-title="test" data-bs-target="#addModal" >@lang('lang.add')</button></div> --}}
		<div class="col-sm-12 mt-3">
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
						<table class="display text-center" id="advance-1">
							<thead>
								<tr>
									<th>@lang('lang.toll_description')</th>
									<th>@lang('lang.road')</th>
									<th>@lang('lang.cost')</th>
									<th>@lang('lang.lat')</th>
									<th>@lang('lang.lng')</th>
									<th class="text-center">@lang('lang.Status')</th>
									<th></th>									
								</tr>
							</thead>
							<tbody>
								@forelse ($tolls as $toll)
									<tr>
										<td>
                                            {{$toll?->toll_description }}
                                        </td>
										
										<td>{{ $toll?->road  }}</td>
										<td>{{ $toll?->cost  }}</td>
										<td>{{ $toll?->lat  }}</td>
										<td>{{ $toll?->lng  }}</td>
										<td class="text-center">
											@if ($toll?->enable == "1")
												<span class="badge badge-success p-2 fs-6">@lang('lang.enable')</span>
											@elseif ($toll?->enable == "0")
												<span class="badge badge-danger p-2 fs-6">@lang('lang.disable')</span>
											@endif
										</td>
										<td>
											<button class="btn btn-primary" type="button" data-bs-toggle="modal" data-original-title="test" data-bs-target="#exampleModal"  onclick="getRecord({{ $toll }})">@lang('lang.edit')</button>
											<form action="{{ route('tolls.enable') }}" method="POST">
											
												@csrf
												<input type="hidden" name="id" value="{{$toll->id}}" id="notification_id">
												
												<button class="btn m-1 btn-secondary" type="submit" >@lang('lang.changeEnable')</button>
												
												
											</form>
										</td>
							
									</tr>
								@empty
									
								@endforelse
								
							</tbody>
							<tfoot>
								<tr>
									<th>@lang('lang.toll_description')</th>
									<th>@lang('lang.road')</th>
									<th>@lang('lang.cost')</th>
									<th>@lang('lang.lat')</th>
									<th>@lang('lang.lng')</th>
									<th class="text-center">@lang('lang.Status')</th>
									<th></th>									
								</tr>							
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	
	</div>
</div>


<div class="modal fade" id="addModal" tabindex="-1" role="dialog" aria-labelledby="addModalLabel" aria-hidden="true">

	<div class="modal-dialog" role="document">
	   <div class="modal-content">
		  <div class="modal-header">
			 <h5 class="modal-title" id="addModalLabel">@lang('lang.add')</h5>
			 <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
		  </div>
		  <div class="modal-body">

			<form class="needs-validation" novalidate="" method="POST" enctype="multipart/form-data" action="{{ route('carModel.store') }}">
				@csrf
				<div class="row">
					<div class="col-md-12 mb-3">
						<label for="section_toll_description">@lang('lang.toll_description')</label>
						<input class="form-control" type="text" name="toll_description" value="" placeholder="Toll" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a Toll.</div>

					</div>
					<div class="col-md-12 mb-3">
						<label for="section_road">@lang('lang.road')</label>
						<input class="form-control"  type="text" name="road" value="" placeholder="name" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a road.</div>
					</div>
					<div class="col-md-12 mb-3">
						<label for="section_cost">@lang('lang.cost')</label>
						<input class="form-control"  type="text" name="cost" value="" placeholder="name" required="">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a cost.</div>
					</div>
				
				</div>
				
				<div class="modal-footer">
					<button class="btn btn-primary" type="button" data-bs-dismiss="modal">@lang('lang.close')</button>
					<button class="btn btn-secondary" type="submit">@lang('lang.save')</button>
				 </div>
			</form>

		  </div>
		  
	   </div>
	</div>
</div>

<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">

	<div class="modal-dialog" role="document">
	   <div class="modal-content">
		  <div class="modal-header">
			 <h5 class="modal-title" id="exampleModalLabel">@lang('lang.edit')</h5>
			 <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
		  </div>
		  <div class="modal-body">

			<form class="needs-validation" novalidate="" method="POST" enctype="multipart/form-data" action="{{ route('tolls.update') }}">
				@csrf
				<input type="hidden" id="section_id" name="id">
				<div class="col-md-12 mb-3">
					<label for="section_toll_description">@lang('lang.toll_description')</label>
					<input class="form-control" type="text" id="section_toll_description" name="toll_description" value="" placeholder="toll" required="">
					<div class="valid-feedback">Looks good!</div>
					<div class="invalid-feedback">Please choose a Toll.</div>

				</div>
				<div class="col-md-12 mb-3">
					<label for="section_road">@lang('lang.road')</label>
					<input class="form-control" id="section_road" type="text" name="road" value="" placeholder="road" required="">
					<div class="valid-feedback">Looks good!</div>
					<div class="invalid-feedback">Please choose a road.</div>
				</div>
				<div class="col-md-12 mb-3">
					<label for="section_cost">@lang('lang.cost')</label>
					<input class="form-control" id="section_cost" type="number" name="cost" value="" placeholder="cost" required="">
					<div class="valid-feedback">Looks good!</div>
					<div class="invalid-feedback">Please choose a cost.</div>
				</div>
			
			</div>
				
				<div class="modal-footer">
					<button class="btn btn-primary" type="button" data-bs-dismiss="modal">@lang('lang.close')</button>
					<button class="btn btn-secondary" type="submit">@lang('lang.edit')</button>
				 </div>
			</form>

		  </div>
		  
	   </div>
	</div>
</div>

@endsection


@section('script')
<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>
<script src="{{asset('assets/js/select2/select2.full.min.js')}}"></script>
<script src="{{asset('assets/js/select2/select2-custom.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/sweetalert.min.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/app.js')}}"></script>

@endsection

<script>

	function getRecord(data){
	
	    document.getElementById("section_toll_description").value=data['toll_description'];
	    document.getElementById("section_road").value=data['road'];
	    document.getElementById("section_cost").value=data['cost'];
		document.getElementById("section_id").value=data['id'];
   }
   


   function getId(id){
	    document.getElementById("notification_id").value=id;
   }
</script>