<?php
namespace App\Http\Controllers;
use App\Events\TestSocketEvent;
use App\Events\AvailableRidesEvent;


//start Socket test
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use Illuminate\Support\Facades\Route;

Route::get('/test-broadcast', function () {
    broadcast(new TestSocketEvent('Hello from WebSocket!'));
    return response()->json(['status' => 'Broadcast sent']);
});
//end Socket test




Route::get('/n', function () {
    return "here now2";
})->name('/n');

Route::get('/driver/rides/realtime', [Driver\RideController::class, 'realTimeRides']);


Route::get('/test-redis-set', function () {
    Redis::setex('ride_request:test', 180, json_encode(['ride_id' => 99]));
    return 'Set';
});


Route::get('/test-event', function () {
    event(new AvailableRidesEvent([
        'ride_id' => 999,
        'lat' => 11.9,
        'lang' => 35.9,
    ], [12])); // Make sure driver 12 is subscribed

    return 'done';
});


Route::get('/test-redis-get', function () {

    $prefix = config('database.redis.options.prefix') ?? '';
    Log::info($prefix);
    $keys = Redis::keys("{$prefix}ride_request:*");
    Log::info("Found Redis keys", $keys);

    $rides = [];

    foreach ($keys as $key) {
        $value = Redis::get($key);
        if ($value) {
            $rides[] = json_decode($value, true);
        }
    }


    return response()->json($rides);
});



Route::get('/testn2', function () {
    return "here testn2";
})->name('/testn2');

//Country
Route::get('countries', [Api\CountriesController::class, 'index']);


Route::get('/genders', [Driver\GenderController::class, 'index']);


Route::get('about_us', [Driver\AboutUsController::class, 'index']);
Route::middleware(['checkLanguage'])->group(function () {
    Route::post('check_client_exists', [Driver\Auth\UserAuthController::class, 'checkClientExists']);

    Route::get('cities', [Driver\CityController::class, 'cities']);
    Route::get('carModels', [Driver\CarModelController::class, 'index']);
    Route::get('carTypes', [Driver\CarTypeController::class, 'index']);
    Route::post('send_otp_register', [Driver\Auth\UserAuthController::class, 'sendOtpRegister']);
    Route::post('reset_password', [Driver\Auth\ResetPasswordController::class, 'resetPassword']);
    
    Route::post('login', [Driver\Auth\UserAuthController::class, 'login']);
    Route::post('register', [Driver\Auth\UserAuthController::class, 'register']);


    //Banner
    Route::get('banners', [Driver\BannerController::class, 'index']);
    

    
Route::middleware(['auth:api','check_user_status'])->group(function () {
    
    
    Route::post('add_driver_interface', [Driver\RideDriverInterfaceController::class, 'add']);
    Route::get('get_driver_interface', [Driver\RideDriverInterfaceController::class, 'index']);
    Route::delete('delete_driver_interface', [Driver\RideDriverInterfaceController::class, 'delete']);
    
    

    //Rides
    Route::get('driver_rides_rate', [Driver\RideController::class, 'getDriverRidesRates']);
    Route::post('rides', [Driver\RideController::class, 'index']);
    Route::get('config', [Driver\RideController::class, 'config']);
    Route::post('reports', [Driver\RideController::class, 'reports']);
    Route::post('rides', [Driver\RideController::class, 'index']);
    Route::post('ride', [Driver\RideController::class, 'details']);
    Route::post('contact-ride', [Driver\RideController::class, 'contactRide']);
    Route::post('start-ride', [Driver\RideController::class, 'startRide']);
    Route::post('update-ride-info', [Driver\RideController::class, 'editRideLocation']);
    Route::post('finish-ride', [Driver\RideController::class, 'finishRide']);
    Route::post('inital-accept-ride', [Driver\RideController::class, 'initalAcceptRide']);
    
    Route::post('cancel-ride', [Driver\RideController::class, 'cancelRide']);
    
     Route::post('delivered-ride', [Driver\RideController::class, 'deliveredRide']);
     
     Route::post('customer-arrived-ride', [Driver\RideController::class, 'customerArrivedRide']);

    Route::post('contactUs', [Driver\ContactUsController::class, 'store']);


    Route::post('edit_password', [Driver\Auth\ResetPasswordController::class, 'editPassword']);

    Route::post('add_client_region', [Driver\CityController::class, 'addClientRegion']);
    Route::post('select_main_address', [Driver\CityController::class, 'updateMainAddress']);
    Route::post('edit_client_region', [Driver\CityController::class, 'editClientRegion']);
    Route::delete('delete_client_region', [Driver\CityController::class, 'deleteClientRegion']);

    //Discount
    Route::post('check_availabilty', [Driver\DiscountController::class, 'checkAvailabilty']);

    //Auth
    Route::get('logout', [Driver\Auth\UserAuthController::class, 'logout']);

    //Profile
    Route::get('profile', [Driver\ProfileController::class, 'index']);
    Route::delete('profile', [Driver\ProfileController::class, 'destroy']);
    Route::post('profile', [Driver\ProfileController::class, 'update']);
    Route::post('updateLang', [Driver\ProfileController::class, 'updateLang']);
    Route::post('updateLocation', [Driver\ProfileController::class, 'updateLocation']);
    Route::get('update-status', [Driver\ProfileController::class, 'updateStatus']);
    Route::get('edit-request', [Driver\ProfileController::class, 'editRequest']);




    
    
    
    
});



Route::get('/daily-bonus', [Driver\DriverRidesBonusLogController::class ,'dailyBonus']);
Route::get('/weekly-bonus', [Driver\DriverRidesBonusLogController::class ,'weeklyBonus']);
Route::get('/monthly-bonus', [Driver\DriverRidesBonusLogController::class ,'monthlyBonus']);


});