<?php
namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;

class MakeService extends Command
{
    protected $signature = 'make:service {name}';
    protected $description = 'Create a new service.';

    public function handle()
    {
        $name = $this->argument('name');
        $serviceClass = $name . 'Service';

        $this->createService($serviceClass);

        $this->info('Service created successfully!');
    }

    protected function createService($serviceClass)
    {
        $serviceStub = __DIR__ . '/stubs/Service.stub';
        $serviceContent = File::get($serviceStub);
        $serviceContent = str_replace('{{class}}', $serviceClass, $serviceContent);

        $servicePath = app_path("Services/{$serviceClass}.php");
        File::put($servicePath, $serviceContent);
    }
}
