<?php

namespace App\Http\Controllers\Admin;

use App\Models\CarType;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\CarType\EditRequest;
use App\Http\Requests\Admin\CarType\StoreRequest;

class CarTypeController extends Controller
{
    public function index()
    {
        $result = CarType::get();
        $pageName="";
        return view("admin.carType.index",compact('result','pageName'));
    }

    public function store(StoreRequest $request)
    {
        CarType::create($request->validated());
        return back()->with('success',trans('lang.created')); 
    }
 
    public function update(EditRequest $request)
    {
        CarType::whereId($request->id)->update($request->validated());
        return back()->with('success',trans('lang.updated')); 
    }


    public function destroy($id)
    {
        //
    }


}
