<?php

namespace App\Http\Controllers\Admin;

use App\Models\{Client};
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Client\EditRequest;
use App\Traits\NotificationTrait;
class ClientController extends Controller
{
   
    use NotificationTrait;
    public function index(Request $request){
        $this->lang();
        $clients=Client::query()
        ->select('id' ,'name'  , 'phone' 
        ,'gender','active',
        'created_at')->get();
        return view('admin.clients.index',compact('clients'));
    }

    public function details(Client $user){
         $this->lang();
     $user= $user->load("region:id,$this->locale","carModel:id,$this->locale","carType:id,$this->locale");
        // return $user;
        return view('admin.clients.details',compact('user'));
    }
    
    public function edit(Client $user){
        
        // return $user;
        // $user=User::find($id);
    //   return $user=json_decode($user,true);
        return view('admin.clients.edit',compact('user'));
    }

    public function update(EditRequest $request,$id){
        // return "here";
        $data=$request->validated();
        // if($user->subscription_end_date<now()){
        //     $data['active']=0;
        // }
        $user=Client::find($request->id);
        $user->update($data);
        // $user->syncRoles([$request->role_id]);
        
        if($request->active==1){
            
            $notification=
            [
                'type' => "1",
                'title' => "حالة المستخدم",
                'title_en' => "User status",
                'message' => "تم تنشيط حسابكم",
                'message_en' => "Your account has been activated",
            ];
            $subscribers=[$user->device_id];
            
            $this->sendNotification($data_send=$notification,$subscribers);
        }
        elseif($request->active==2){
            
            $notification=
            [
                'type' => "1",
                'title' => "حالة المستخدم",
                'title_en' => "User status",
                'message' => "تم ايقاف حسابكم مؤقتا الرجاء التواصل مع الدعم",
                'message_en' => "Your account is temporarily suspended. Please contact support",
            ];
            $subscribers=[$user->device_id];
      
            $this->sendNotification($data_send=$notification,$subscribers);
            
        }
       
        return  to_route('admin.clients')->with('success',trans('lang.updated')); 
    }


    public function changeStatus(Client $client){
        $status=!$client->active;
        $client->update(['active' => $status]);
        return back()->with('success',trans('lang.updated'));
    }


    public function resetPassword(Request $request){
        $client=Client::find($request->client_id);
        $client->update(['password' => $request->password]);
        return back()->with('success',trans('lang.updated'));
    }
}
