<?php

namespace App\Http\Controllers\Admin;

use App\Models\Discount;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\Discount\StoreRequest;

class DiscountController extends Controller
{
    public  function index(){
        $discounts=Discount::orderByDESC('id')->get();
        return view('admin.discount.index',compact('discounts'));
    }

    public function create(){
        return view('admin.discount.add');
    }

    public function store(StoreRequest $request){
        $data=$request->validated();
        Discount::create($data);
        return  to_route('discounts.index')->with('success',trans('lang.created'));
    }

    public function changeActive($id){
        $discount=Discount::find($id);
        $active=!$discount->active;
        $discount->update(['active' => $active]);
        return back()->with('success',trans('lang.updated'));
    }
}
