<?php

namespace App\Http\Controllers\Driver;

use App\Models\RideDriver;
use App\Models\RideContacts;
use Illuminate\Http\Request;
use App\Services\RideService;
use App\Traits\ResponsesTrait;
use App\Jobs\CalculateDistance;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use App\Repositories\RideRepository;
use App\Services\CalculateDistanceService;
use App\Http\Requests\Client\Ride\EndRequest;
use App\Http\Requests\Client\Ride\EditRequest;
use App\Http\Requests\Client\Ride\StoreRequest;
use App\Http\Requests\Client\Ride\ContactRideRequest;
use Carbon\Carbon;
use DB;
use App\Http\Resources\ReportResource;
use App\Models\AppConfiguration;
use App\Traits\FileUploadTrait;

class RideController extends Controller
{
    use ResponsesTrait;
    use FileUploadTrait;

    private $rideRepository,$rideService,$calculateDistanceService;
    public function __construct(RideRepository $rideRepository, RideService $rideService)
    {
        $this->rideRepository = $rideRepository;  
        $this->rideService = $rideService;  
    }
    
     function contactRide(ContactRideRequest $request){
        Log::info("contactRide" );
        $data=$request->validated();
        $data['driver_id']=auth()->user()->id;
        if($request->type=="image"){
          $data['name']=  $this->uploadFile($request->name,'contacts', "");
        }
        RideContacts::create($data);
        return $this->success(null,trans('lang.created'));
    
    }

    function config(Request $request){
        $appConfiguration=AppConfiguration::whereCityId(auth()->user()->city_id)->select('km_price','moto_km_price','start_fee')->first();
        return $this->success($appConfiguration);
    }
    
     function getDriverRidesRates(Request $request){
        // $rides=RideDriver::whereUserId(auth()->id())->first();
       return $this->success($this->rideService->getDriverRidesRates($request));
    }
    
    function reports(Request $request){
        Log::info("reports" );

        // $currentDate = Carbon::now();
        // $startDate = $currentDate->startOfWeek()->format('Y-m-d');
        // $endDate = $currentDate->endOfWeek()->format('Y-m-d');
        
        $currentDate = Carbon::now();
        $sevenDaysAgo = $currentDate->subDays(6); 
        $endDate = Carbon::now()->addDays(1)->format('Y-m-d');
        $startDate = $sevenDaysAgo->format('Y-m-d');
        $monthAgo = $currentDate->subDays(30); 
        $monthDate = $monthAgo->format('Y-m-d');
        // $currentDate = \Carbon\Carbon::create(2023, 10, 24);
        
 

       
        
        // Display the start and end dates of the week
        // return "Start of the week: " . $startDate;
        // return "End of the week: " . $endDate;
        $today = now()->toDateString();
         $rides=RideDriver::query()
        ->whereUserId(auth()->id())
        ->whereDate('created_at', $today)
        ->select('id','start_fee','actual_price','total_waiting_time_fee','actual_time','created_at','updated_at')
        ->get();
        
        
        $daily=[
            "grand_total"=>number_format($rides->sum('start_fee') +$rides->sum('actual_price')+$rides->sum('total_waiting_time_fee'),2),
            "total_time"=>(number_format(((Integer)($rides->sum('actual_time')/60)),0)).":".($rides->sum('actual_time')%60),
            "total_trips"=>$rides->count()
        ];
        
        // return 
        // Log::info("startDate ". $startDate );
        // Log::info("endDate ". $endDate );
        
     $weeklyRides = RideDriver::query()
    ->whereUserId(auth()->id())
    ->where('created_at','>=',$startDate)
    ->where('created_at','<=',$endDate)
    // ->whereBetween('created_at', [$startDate, $endDate])
    ->select(
        DB::raw('DATE(created_at) as formatted_date'),
        'user_id',
        DB::raw('Count(id) as count'),
        DB::raw('SUM(start_fee) as sum_start_fee'),
        DB::raw('SUM(actual_price) as sum_actual_price'),
        DB::raw('SUM(total_waiting_time_fee) as sum_total_waiting_time_fee'),
        DB::raw('SUM(actual_time) as sum_actual_time')
    )
    ->groupBy('formatted_date', 'user_id')
    ->get();
    
    $monthlyRides = RideDriver::query()
    ->whereUserId(auth()->id())
    ->whereBetween('created_at', [$monthDate, $endDate])
    ->select(
        DB::raw('DATE(created_at) as formatted_date'),
        'user_id',
        DB::raw('Count(id) as count'),
        DB::raw('SUM(start_fee) as sum_start_fee'),
        DB::raw('SUM(actual_price) as sum_actual_price'),
        DB::raw('SUM(total_waiting_time_fee) as sum_total_waiting_time_fee'),
        DB::raw('SUM(actual_time) as sum_actual_time')
    )
    ->groupBy('formatted_date', 'user_id')
    ->get();
    
    

        $weekly= ReportResource::collection($weeklyRides);
        $monthly= ReportResource::collection($monthlyRides);
        $totalWeekly=[
            'weekly_grand_total'=>number_format($weeklyRides->sum('sum_start_fee') +$weeklyRides->sum('sum_actual_price')+$weeklyRides->sum('sum_total_waiting_time_fee'),2),
            "weekly_total_time"=>(number_format(((Integer)($weeklyRides->sum('sum_actual_time')/60)),0)).":".($weeklyRides->sum('sum_actual_time')%60),
            "weekly_total_trips"=>$weeklyRides->sum('count')
        ];
        $totalmonthly=[
            'weekly_grand_total'=>number_format($monthlyRides->sum('sum_start_fee') +$monthlyRides->sum('sum_actual_price')+$monthlyRides->sum('sum_total_waiting_time_fee'),2),
            "weekly_total_time"=>(number_format(((Integer)($monthlyRides->sum('sum_actual_time')/60)),0)).":".($monthlyRides->sum('sum_actual_time')%60),
            "weekly_total_trips"=>$monthlyRides->sum('count')
        ];
        // return "here";
        
        $reports=[
            "daily" => $daily,
            "weekly" => $weekly,
            "weekly_total" => $totalWeekly,
            "monthly" =>$monthly,
            "monthly_total"=>$totalmonthly
        ];
           return $this->success($reports);
        // $rides=RideDriver::query()
        // ->whereUserId(auth()->id());
        // if($request->from && $request->to){
        //     $rides=$rides->whereBetween('created_at', [$request->from, $request->to]);
        // }
        // $rides=$rides
        // ->select('id','created_at','start_fee','actual_distance',
        // 'total_waiting_time','total_waiting_time_fee','actual_price')
        // ->get();
        // $reports=[
        //     'total_trips'=>$rides->count(),
        //     'total_start_fee'=>number_format($rides->sum('start_fee'),2),
        //     'total_km'=>number_format( $rides->sum('actual_distance'),2),
        //     'total_waiting_time'=>$rides->sum('total_waiting_time'),
        //     'grand_total'=>number_format($rides->sum('start_fee') +$rides->sum('actual_price')+$rides->sum('total_waiting_time_fee'),2),
        // ];
        // return $this->success($reports);
    }


    function index(Request $request){
        Log::info("index" );
        $rides=RideDriver::whereUserId(auth()->id());
        if($request->from && $request->to){
            $rides=$rides->whereBetween('created_at', [$request->from, $request->to]);
        }
        $rides=$rides->with(["endPoints",'startPoint'])
        ->select('id','created_at')
        ->orderByDESC('id')
        ->get();
        return $this->success($rides);
    }
    


    #TODO need to change in future
    // function details(){
    //     // $rides=RideDriver::whereUserId(auth()->id())->first();
    //     return $this->success($this->rideService->finishRide($request));
    // }
    
    function details(Request $request){
        // $rides=RideDriver::whereUserId(auth()->id())->first();
       return $this->success($this->rideService->rideDetails($request));
    }

    function startRide(StoreRequest $request){
        Log::info("startRide" );
        $ride=$this->rideService->startRide($request);
        return $this->success(['id'=>$ride->id],trans('lang.created'));
        // CalculateDistance::dispatch();
        // return $this->success(null,trans('lang.updated'));
    }

    function editRideLocation(Request $request){
        Log::info("editRideLocation" );
        $ride=$this->rideService->editRideLocation($request);
        return $this->success($ride,trans('lang.updated'));
    }

    function finishRide(EndRequest $request){
        Log::info("finishRide" );
        // $ride=$this->rideService->finishRide($request);
        // Log::info("finish Ride response " .$ride );
        return $this->success($this->rideService->finishRide($request));
    }

    function initalAcceptRide(Request $request){
        Log::info("acceptNotDelivered" );
        $data=$this->rideService->initalAcceptRide($request);
        // $ride=$this->rideService->finishRide($request);
        // Log::info("finish Ride response " .$ride );
        return $this->success($data);
    }
    
    function deliveredRide(Request $request){
        Log::info("acceptDelivered" );
        $data=$this->rideService->deliveredRide($request);
        // $ride=$this->rideService->finishRide($request);
        // Log::info("finish Ride response " .$ride );
        return $this->success($data);
    }
}
