<?php

namespace App\Http\Requests\Admin\AppConfiguration;

use Illuminate\Foundation\Http\FormRequest;

class EditRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

        /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'id' => "required",
            'km_price' => "sometimes|nullable",
            'moto_km_price' => "sometimes|nullable",
            'airport_fee' => "sometimes|nullable",
            'start_fee' => "sometimes|nullable",
            'waiting_price' => "sometimes|nullable",
        ];
    }

    public function messages(): array {
        return [
            'city_id.unique'  => 'This city has configuration',
        ];
    }
}
