<?php

namespace App\Http\Requests\Admin\CarModel;

use Illuminate\Foundation\Http\FormRequest;

class EditRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'id' => 'required',
            'name_ar' => "sometimes|nullable|unique:car_models,name_ar, ".$this->id,
            'name_en' => "sometimes|nullable|unique:car_models,name_en, ".$this->id,
        ];
    }

    public function messages(): array {
        return [
            'name_ar.unique'  => 'This name already used.',
            'name_en.unique'  => 'This name already used.',
        ];
    }
}
