<?php

namespace App\Http\Requests\Admin\Role;

use Illuminate\Foundation\Http\FormRequest;

class StoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => "required|unique:roles,name"
        ];
    }
    
    public function messages(): array {
        return [
            'name.required'  => 'يجب اختيار اسم للصلاحية',
            'name.unique' => "تم انشاء هذا الاسم من قبل"
        ];
    }
}
