<?php

namespace App\Http\Requests\Client\Auth;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ResponsesTrait;

class RegisterRequest extends FormRequest
{
    use ResponsesTrait;

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->failed(null,$validator->errors()->first()));
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            'name' => 'required|max:255',
            'phone' => 'required|unique:clients,phone',
            'password' => 'required',
            'device_id' => 'required',
            // 'birth_date' => 'required',
            'img_path' => 'sometimes|nullable|file',
            // 'gender' => 'required',
            'lat' => 'required',
            'lang' => 'required',
            'otpCode' => 'required',
            // 'vechile_type' => 'required',
            // 'city_id' => 'required',
        ];
    }

    public function messages(): array {
        return [
            'phone.unique'  => __('lang.phoneFound'),
            'phone.required'  => 'The phone Is required.',
            'name.required'  => 'The name Is required.',
            'password.required'  => 'The password Is required.',
            'birth_date.required'  => 'The birth_date Is required.',
            'gender.required'  => 'The gender Is required.',
            'lat.required'  => 'The lat Is required.',
            'lang.required'  => 'The lang Is required.',
            'otpCode.required'  => 'The otpCode Is required.',
        ];
    }
}
