<?php

namespace App\Http\Requests\Client;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ResponsesTrait;

class EditProfileRequest extends FormRequest
{
    use ResponsesTrait;

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
    protected $stopOnFirstFailure = true;


    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'phone' => 'sometimes|nullable|unique:users,phone,'.auth()->id(),
            'car_color' => 'sometimes|nullable',
            'car_license' => 'sometimes|nullable|file',
            'driving_license' => 'sometimes|nullable|file',
            'image' => 'sometimes|nullable|file',
            'model_year' => 'sometimes|nullable',
            'car_type_id' => 'sometimes|nullable',
            'car_model_id' => 'sometimes|nullable',
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->failed(null,$validator->errors()->first()));
    }

    public function messages(): array {
        return [
            'phone.unique'  => __('lang.phoneFound'),
        ];
    }
}
