<?php

namespace App\Http\Requests\Client\Ride\Rate;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use App\Traits\ResponsesTrait;
use Illuminate\Foundation\Http\FormRequest;
class StoreRequest extends FormRequest
{
    use ResponsesTrait;
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
    protected $stopOnFirstFailure = true;

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'id' => 'required',
            'client_description' => 'sometimes|nullable',
            'car_rate' => 'required',
            'driver_rate' => 'required',
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->failed(null,$validator->errors()->first()));
    }

    public function messages(): array {
        return [
            'id.required'  => 'The id is required.',
            'client_description.required'  => 'The client description  is required.',
            'car_rate.required'  => 'The car rate is required.',
            'driver_rate.required'  => 'The driver rate is required.',
        ];
    }
}
