<?php

namespace App\Http\Requests\Client\Ride;

use App\Traits\ResponsesTrait;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
class StoreRequest extends FormRequest
{
    use ResponsesTrait;
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
    protected $stopOnFirstFailure = true;

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'total_time' => 'sometimes|nullable',
            'total_distance' => 'sometimes|nullable',
            'points' => 'required',
            "gender" => "sometimes|nullable",
            "vechile_type" => "sometimes|nullable"
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->failed(null,$validator->errors()->first()));
    }

    public function messages(): array {
        return [
            'total_time.required'  => 'The total_time Is required.',
            'total_distance.required'  => 'The total_distance Is required.',
            'points.required'  => 'The points is required.',
            'points.array'  => 'The points should be array.',
        ];
    }
}
