<?php

namespace App\Traits;
use Illuminate\Support\Facades\Log;
use GuzzleHttp\Client;

trait SendSmsTrait
{
    public function sendSmsWhatsApp($phone, $otp)
    {
        Log::info("sendSmsWhatsApp:-" .$phone );

        $message ="your OTP is :- $otp";
        $url = 'https://app.arrivewhats.com/api/send';

        $params = [
            'query' => [
                'number' => $phone,
                'type' => 'text',
                'message' => $message,
                'instance_id' => '677B9932B98B8',
                'access_token' => '67696972332f4',
            ],
        ];

        $client = new Client();
        $promise = $client->getAsync($url, $params);

        try {
            $response = $promise->wait(); // Block until the request is complete
            $responseData = json_decode($response->getBody(), true);

            Log::info('WhatsApp OTP sent successfully.', ['response' => $responseData]);

            return [
                'success' => true,
                'data' => $responseData,
            ];
        } catch (\Throwable $exception) {
            Log::error('Failed to send WhatsApp OTP.', ['error' => $exception->getMessage()]);
                Log::info("sendOtpAsync:success"  );

            return [
                'success' => false,
                'error' => $exception->getMessage(),
            ];
        }
    }

    
    // public function sendSmsWhatsApp($phone, $otp)
    // {
    //     // echo $phone;

    //     $curl = curl_init();

    //     curl_setopt_array($curl, array(
    //       CURLOPT_URL => 'https://graph.facebook.com/v17.0/155245960986867/messages',
    //       CURLOPT_RETURNTRANSFER => true,
    //       CURLOPT_ENCODING => '',
    //       CURLOPT_MAXREDIRS => 10,
    //       CURLOPT_TIMEOUT => 0,
    //       CURLOPT_FOLLOWLOCATION => true,
    //       CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    //       CURLOPT_CUSTOMREQUEST => 'POST',
    //       CURLOPT_POSTFIELDS =>'{
    //       "messaging_product": "whatsapp",
    //       "recipient_type": "individual",
    //       "to": "'.$phone.'",
    //       "type": "template",
    //       "template": {
    //         "name": "otp",
    //         "language": {
    //           "code": "en_US"
    //         },
    //         "components": [
    //           {
    //             "type": "body",
    //             "parameters": [
    //               {
    //                 "type": "text",
    //                 "text": "'.$otp.'"
    //               }
    //             ]
    //           },
    //           {
    //             "type": "button",
    //             "sub_type": "url",
    //             "index": "0",
    //             "parameters": [
    //               {
    //                 "type": "text",
    //                 "text": "'.$otp.'"
    //               }
    //             ]
    //           }
    //         ]
    //       }
    //     }',
    //       CURLOPT_HTTPHEADER => array(
    //         'Authorization: Bearer EAAOUNML7b7QBO3MHBIud9mnjfZBS5X5KwuIaUvhYKwygerBmSJaxd3TZA79C55kUzztwybkbydEmVOA8bQblfTdEnKYK4FaxSkZC4mR1zGdPgXxtpZA4ZC3a3ZCVudehZCVMfX7n2AdlTfcjMoZBFlTdWI8Ed8WtYAnWah9l9AEHVVyf6n2wf2wrDXYdj5e2jwUW',
    //         'Content-Type: application/json'
    //       ),
    //     ));
        
    //     $response = curl_exec($curl);
        
    //     curl_close($curl);
    //     // echo $response;
    // }
}
