<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ride_driver', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->index();
            $table->boolean("status")->default(false);
            $table->float('total_price');
            $table->float('actual_price')->nullable();
            $table->float('total_time');
            $table->float('start_fee')->default(0);
            $table->float('actual_time')->nullable();
            $table->float('total_distance');
            $table->float('actual_distance')->default(0);
            $table->float('total_waiting_time')->default(0);
            $table->float('total_waiting_time_fee')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ride_driver');
    }
};
