@extends('admin.layout.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">
@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3>@lang('lang.clients')</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">@lang('lang.Users')</li>
<li class="breadcrumb-item active">@lang('lang.clients')</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">

		<div class="col-sm-12">
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
						<table class="display" id="advance-1">
							<thead>
								<tr class="text-center">
                                    <th>@lang('lang.Name')</th>
									<th class="text-center">@lang('lang.phone')</th>
									<th class="text-center">@lang('lang.Status')</th>
									<th>@lang('lang.gender')</th>
									<th>@lang('lang.created_at')</th>
									<th></th>								
								</tr>
							</thead>
							<tbody>
								@forelse ($clients as $client)
									<tr class="text-center">
										<td>{{ $client->name }}</td>
										<td class="text-center">{{ $client->phone}}</td>
										<td class="text-center">
											@if ($client->active ==1)
											@lang('lang.active')
											@elseif($client->active ==2)
											@lang('lang.stop')	

											@else
											@lang('lang.inactive')	
											@endif
											
										</td>
                                        <td class="text-center">{{ $client->gender}}</td>

										<td>{{ $client->created_at?->format('Y-m-d') }}</td>
										<td>
											 @can('edit admin')
                                             @if ($client->active ==1)
                                                <a class="btn btn-success"  href="{{ route('admin.clients.changeStatus',$client) }}">
                                                    @lang('lang.active')
                                                </a>
                                            @else
                                                <a class="btn btn-danger"  href="{{ route('admin.clients.changeStatus',$client) }}">
                                                    @lang('lang.inactive')
                                                </a>
                                            @endif
											@endcan	
											{{--
											@can('edit admin')
											<a class="btn btn-success"  href="{{ route('admin.drivers.details',$client) }}">
												@lang('lang.details')</a>
											@endcan	 --}}

										</td>
									</tr>
								@empty
									
								@endforelse
								
							</tbody>
							<tfoot>
							<tr class="text-center">
									<th>@lang('lang.Name')</th>
									<th class="text-center">@lang('lang.phone')</th>
									<th class="text-center">@lang('lang.Status')</th>
									<th>@lang('lang.gender')</th>
									<th>@lang('lang.created_at')</th>
									<th></th>								
								</tr>
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	
	</div>
</div>



@endsection
<script>

	function getId(id){
		document.getElementById("client_id").value=id;
	}
	</script>
@section('script')

<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>
@endsection