<?php if(isset($ride)): ?>

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="icon" href="<?php echo e(asset('assets/images/logo/logo.png')); ?>" type="image/x-icon">
    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/logo/logo.png')); ?>" type="image/x-icon">
    <title>Ride Information</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            text-align: center;
            background-color: #FEDE00;
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        .ride-info {
            width: 300px;
            padding: 20px;
            border: 1px solid #ccc;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            background-color: #fff;
        }
        .ride-info h2 {
            margin-top: 0;
        }
        .ride-info p {
            margin: 5px 0;
        }
    </style>
</head>
<body>
    <div class="ride-info">
        <h2>Ride Information</h2>
        <p>Total Waiting Time Fee: $<?php echo e($ride->total_waiting_time_fee); ?></p>
        <p>Start Fee: EGP<?php echo e($ride->start_fee); ?></p>
        <p>Actual Distance: <?php echo e($ride->actual_distance); ?> KM</p>
        <p>Actual Price: EGP<?php echo e($ride->actual_price); ?></p>
        <p>Start Point: <?php echo e($ride?->startPoint?->name); ?></p>
        <br>
       <?php if(isset($ride->endPoints)): ?>
            <?php $__currentLoopData = $ride->endPoints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $endPoint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <p>End Point: <?php echo e($endPoint->name); ?></p>
                <br>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>

      

        
    </div>
</body>
</html>


<?php endif; ?>
<?php /**PATH /home/richiestekw/public_html/rides/resources/views/client_profile.blade.php ENDPATH**/ ?>