<?php

namespace App\Http\Controllers\Driver;

use App\Traits\ResponsesTrait;
use App\Http\Controllers\Controller;
use App\Repositories\CrudRespositoryInterface;
use App\Models\RideDriverInterface;
use Illuminate\Http\Request;
use App\Http\Requests\Driver\RideDriverInterfaceStoreRequest;

class RideDriverInterfaceController extends Controller
{
    use ResponsesTrait;

    
    public function index(){
        $result=RideDriverInterface::where("driver_id",auth()->user()->id)
        ->get();
        return $this->success($result );
    }
    
    public function add(RideDriverInterfaceStoreRequest $request){
        $data=$request->validated();
        $data['driver_id']=auth()->user()->id;
        $result=RideDriverInterface::create($data);
        return $this->success($result,trans('lang.created') );
    }
    
    public function delete(Request $request){
        RideDriverInterface::destroy($request->id);
        return $this->success(null,trans('lang.deleted'));
    }
}
