<?php

namespace App\Http\Requests\Auth;

use App\Traits\ResponsesTrait;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;

class RegisterRequest extends FormRequest
{
    use ResponsesTrait;

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
    protected $stopOnFirstFailure = true;


    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            'name' => 'required|max:255',
            'phone' => 'required',
            'password' => 'required',
            'device_id' => 'required',
            'birth_date' => 'required',
            'lang' => 'sometimes|nullable',
            'model_year' => 'sometimes|nullable',
            'car_model_id' => 'sometimes|nullable',
            'car_type_id' => 'sometimes|nullable',
            'driving_license' => 'sometimes|nullable|file',
            'car_license' => 'sometimes|nullable|file',
            'image' => 'sometimes|nullable|file',
            'car_image' => 'sometimes|nullable|file',
            'check_image' => 'sometimes|nullable|file',
            'blood_analysis' => 'sometimes|nullable|file',
            'criminal_record' => 'sometimes|nullable|file',
            'city_id' => 'required',
            'gender' => 'required',
            'vechile_type' => 'required',
            // 'social_status' => 'required',
        ];
    }

    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException($this->failed(null,$validator->errors()->first()));    }

    public function messages(): array {
        return [
            'phone.unique'  => 'The phone Is found.',
        ];
    }
}
