<?php

namespace App\Providers;

use App\Repositories\UserRepository;
use App\Repositories\AboutUsRepository;
use App\Repositories\CarTypeRepository;
use Illuminate\Support\ServiceProvider;
use App\Repositories\CarModelRepository;
use App\Repositories\UserRepositoryInterface;
use App\Repositories\CrudRespositoryInterface;
use App\Http\Controllers\Driver\AboutUsController;
use App\Http\Controllers\Driver\CarTypeController;
use App\Http\Controllers\Driver\CarModelController;

class RepositoryServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->when(CarModelController::class)
        ->needs(CrudRespositoryInterface::class)
        ->give(CarModelRepository::class);

        $this->app->when(CarTypeController::class)
        ->needs(CrudRespositoryInterface::class)
        ->give(CarTypeRepository::class);

        $this->app->when(AboutUsController::class)
        ->needs(CrudRespositoryInterface::class)
        ->give(AboutUsRepository::class);
        
    }
    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        $this->app->bind(UserRepositoryInterface::class, UserRepository::class);
        $this->app->bind(UserRepositoryInterface::class, UserRepository::class);
        // $this->app->bind(CrudRespositoryInterface::class, UserRepository::class);
    
    }
}
