<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

 class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->softDeletes();
            $table->tinyInteger("active")->default(0);
            // $table->string('email')->unique()->nullable();
            $table->string('phone')->unique();
            $table->unsignedBigInteger('city_id')->nullable()->index();
            $table->unsignedBigInteger('car_model_id')->nullable()->index();
            $table->unsignedBigInteger('car_type_id')->nullable()->index();
            // $table->enum('gender',["male","female"])->nullable();
            $table->string('password');
            $table->string('image')->nullable();
            $table->string('driving_license')->nullable();
            $table->string('car_license')->nullable();
            $table->string('car_color')->nullable();
            $table->string('device_id')->nullable();
            $table->string('lang',30)->nullable();
            $table->string('lat',30)->nullable();
            $table->date("subscription_start_date")->nullable();
            $table->date("subscription_end_date")->nullable();
            $table->integer("subscription_number")->default(0);
            // $table->string('building_type',30)->nullable();
            // $table->string('floor_no',30)->nullable();
            // $table->string('flat_no',30)->nullable();
            // $table->string('building_no',30)->nullable();
            // $table->string('block_no',30)->nullable();
            // $table->string('street')->nullable();
            // $table->string('avenue')->nullable();
            // $table->text('notes')->nullable();
            // $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
};
