@extends('admin.layout.master')
@section('title', 'Validation Forms')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/select2.css')}}">

@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3>@lang('lang.addAppConfiguration')</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">@lang('lang.AppConfiguration')</li>
<li class="breadcrumb-item active">@lang('lang.add_AppConfiguration')</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
		<div class="col-sm-12">
			<div class="card">
			
				<div class="card-body">
					<form class="needs-validation" novalidate="" method="POST" enctype="multipart/form-data" action="{{ route('AppConfiguration.store') }}">
                        @csrf
						<div class="row">
							<div class="col-md-6 mb-3">
                                <label for="section_name">@lang('lang.km_price')</label>
                                <input class="form-control" id="km_price" type="number" name="km_price" value="" placeholder="@lang('lang.km_price')" required="" step="0.01">
                                <div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a name.</div>
        
                            </div>
							<div class="col-md-6 mb-3">
                                <label for="section_name">@lang('lang.moto_km_price')</label>
                                <input class="form-control" id="moto_km_price" type="number" name="moto_km_price" value="" placeholder="@lang('lang.km_price')" required="" step="0.01">
                                <div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a name.</div>
        
                            </div>
                            
                             <div class="col-md-6 mb-3">
                                <label for="section_name">@lang('lang.airport_fee')</label>
                                <input class="form-control" id="airport_fee" type="number" name="airport_fee" value="" placeholder="@lang('lang.airport_fee')" required="" step="0.01">
                                <div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a airport_fee.</div>
        
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="section_name">@lang('lang.start_fee')</label>
                                <input class="form-control" id="start_fee" type="number" name="start_fee" value="" placeholder="@lang('lang.start_fee')" required="" step="0.01">
                                <div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a name.</div>
        
                            </div>
        
                            <div class="col-md-6 mb-3">
                                <label for="section_name">@lang('lang.waiting_price')</label>
                                <input class="form-control" id="waiting_price" type="number" name="waiting_price" value="" placeholder="@lang('lang.waiting_price')" required="" step="0.01">
                                <div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a name.</div>
        
                            </div>										
						</div>

						<div class="row">
							<div class="col-md-6 mb-3">
                                <label for="validationCustom03">@lang('lang.region')</label>

                                <select class="js-example-placeholder-multiple col-sm-12"  id="validationCustom03"  name="city_id" required >
                                    <option value=""></option>

                                    @forelse ($cities as $category)
                                        <option value="{{ $category->id }}">{{ $category->name }}</option>
                                    @empty
                                        
                                    @endforelse
                              
                                </select>
                                <div class="invalid-feedback">Please provide a valid category.</div>

                            </div>
				
						</div>

						<button class="btn btn-primary" type="submit">@lang('lang.save')</button>
					</form>
				</div>
			</div>
			
		
		</div>
	</div>
</div>
@endsection

@section('script')
<script src="{{asset('assets/js/select2/select2.full.min.js')}}"></script>
<script src="{{asset('assets/js/select2/select2-custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>
@endsection