@extends('admin.layout.master')
@section('title', 'Bootstrap Basic Tables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/select2.css')}}">

@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3>@lang('lang.order_details')</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">@lang('lang.Orders')</li>
<li class="breadcrumb-item active">@lang('lang.order_details')</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
		<div class="col-sm-12">
			<div class="card">
				{{-- <div class="card-header">
					<h5>Basic Table</h5>
					<span>Use a class<code>table</code> to any table.</span>
				</div> --}}
				<div class="table-responsive">
					<table class="table">
						<thead>
							<tr>
								<th scope="col">#</th>
								<th scope="col">@lang('lang.Name')</th>
								<th class="text-center">@lang('lang.quantity')</th>
                                <th class="text-center">@lang('lang.price')</th>

							</tr>
						</thead>
						<tbody>
                            @foreach (collect($order)['order_details'] as $item)
                                <tr>
                                    <th scope="row">{{$loop->iteration}}</th>
                                    <td>{{ $item['product']['name'] }}</td>
                                    <td class="text-center">{{ $item['quantity'] }}</td>
                                    <td class="text-center">{{ $item['price'] }}</td>
                                </tr> 
                            @endforeach
							
						
						</tbody>
                        <tfoot>
                            <tr>
                              <td>@lang('lang.Total_Price')</td>
                              <td>{{ $order['total_price'] }}</td>
                            </tr>
                        </tfoot>
					</table>
					@can('assign order driver')
					<div class="card-body">
						<form class="needs-validation" novalidate="" method="POST" enctype="multipart/form-data" action="{{ route('order.assign_driver') }}">
							@csrf
							<div class="row">
							
								<input type="hidden" name="id" value="{{ $order->id }}">
								<div class="col-md-6 mb-3">
									<label for="validationCustom01">@lang('lang.Drivers')</label>
	
									<select class="js-example-placeholder-multiple col-sm-12"  id="validationCustom01"  name="driver_id"  >
										<option value=""></option>

										@forelse ($drivers as $driver)
	
											<option value="{{ $driver->id }}" @selected($driver->id == $order->driver_id)>{{ $driver->name }}</option>
										@empty
											
										@endforelse
								  
									</select>
									<div class="invalid-feedback">Please provide a valid Drivers.</div>
	
								</div>
	
								
							</div>
							
	
							<div class="text-center">
								<button class="btn btn-primary" type="submit">@lang('lang.edit')</button>
							</div>
						</form>
					</div>
					@endcan	


				</div>
			</div>
		</div>
	</div>
</div>
@endsection

@section('script')
<script src="{{asset('assets/js/select2/select2.full.min.js')}}"></script>
<script src="{{asset('assets/js/select2/select2-custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>
@endsection