<?php

namespace App\Http\Controllers\Client;

use App\Traits\{ResponsesTrait};
use App\Http\Controllers\Controller;
use App\Http\Requests\Client\Profile\EditRequest;
use Illuminate\Http\Request;

class ProfileController extends Controller
{
    use ResponsesTrait;
    public function profile(){
        return $this->success( auth()->guard("client")->user());
    }

    public function update(EditRequest $request){
        $user =auth()->guard("client")->user();
        $user->update($request->validated());
        return $this->success($user,trans('lang.updated'));
    }


    public function destroy(){
        auth()->guard("client")->user()->delete();
        return $this->success(null,trans('lang.deleted'));
    }

    function updateLang(Request $request){
        // Log::info("update lang" );
        auth() ->guard("client")->user()->update(['lang'=>$request->lang]);
        return $this->success(null,trans('lang.updated'));
    }

}
