<?php

namespace App\Models;
use Laravel\Passport\HasApiTokens;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Support\Str;
use App\Traits\FileUploadTrait;

class Client  extends Authenticatable
{

   use  FileUploadTrait;
    protected $guard="client";
    protected $primaryKey = 'id';

    // Set primary key type to string
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table="clients";
    use HasApiTokens, Notifiable;
    protected $fillable = [
        'name' , 'phone',
        'password' , 'active',
        'device_id' , 'gender',
        'img_path',   'lang',
        'lat'
    ];

    protected $hidden = 
    [
        'password',
        'device_id',
        'updated_at'
    ];


    public function findForPassport(string $username): Client
    {
        return $this->where('username', $username)->first();
    }

    public static function clientUuids()
    {
        return true;
    }

    public function validateForPassportPasswordGrant(string $password): bool
    {
        return Hash::check($password, $this->password);
    }

    public function setPasswordAttribute($value)
    {
        if(!is_null($value))
            $this->attributes['password'] = bcrypt($value);
    }

    public function setImgPathAttribute($value)
    {
        $this->attributes['img_path'] = $this->uploadFile($value,'drivers',$this->attributes['img_path'] ?? "");
    }

    public function cities()
    {
        return $this->belongsToMany(City::class);
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->id = (string) Str::uuid();
        });
    }

}
