<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
class Seller extends Authenticatable
{
    use HasFactory;
    protected $guard = 'seller';
    protected $fillable = [
        'name' , 'email',
        'password' , 'active'
    ];

    protected $hidden = 
    [
        'password' , 'updated_at'
    ];

    public function setPasswordAttribute($value){
        if(!is_null($value))
            $this->attributes['password'] = bcrypt($value);
    }

    public function categories()
    {
        return $this->belongsToMany(Category::class);
    }
   
    public function cities()
    {
        return $this->belongsToMany(City::class);
    }

}
