<?php

namespace App\Http\Controllers\Admin;

use App\Models\City;
use Illuminate\Http\Request;
use App\Models\AppConfiguration;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\AppConfiguration\EditRequest;
use App\Http\Requests\Admin\AppConfiguration\StoreRequest;

class AppConfigurationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index()
    {
        $this->lang();
        $result = AppConfiguration::with("city:id,$this->locale")->get();
        return view('admin.appConfiguration.index',compact('result'));
    }


    public function create()
    {
        $this->lang();
        $cities=City::whereNotNull('parent_id')->select('id',"$this->locale")->get();
        return view('admin.appConfiguration.add',compact('cities'));
    }
     /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

    public function store(StoreRequest $request)
    {
        AppConfiguration::create($request->validated());
        return back()->with('success',trans('lang.created')); 
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(EditRequest $request)
    {
        AppConfiguration::whereId($request->id)->update($request->validated());
        return back()->with('success',trans('lang.updated')); 
    }

}
